/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.OptionalFeature;

public interface NamedFactory<T>
extends Factory<T>,
NamedResource {
    public static <T> T create(Collection<? extends NamedFactory<? extends T>> factories, String name) {
        NamedFactory<T> f = NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, factories);
        if (f != null) {
            return f.create();
        }
        return null;
    }

    public static <S extends OptionalFeature, E extends NamedResource> List<E> setUpTransformedFactories(boolean ignoreUnsupported, Collection<? extends S> preferred, Function<? super S, ? extends E> xform) {
        return preferred.stream().filter(f -> ignoreUnsupported ? f.isSupported() : true).map(xform).collect(Collectors.toList());
    }

    public static <E extends NamedResource & OptionalFeature> List<E> setUpBuiltinFactories(boolean ignoreUnsupported, Collection<? extends E> preferred) {
        return preferred.stream().filter(f -> ignoreUnsupported ? ((OptionalFeature)((Object)f)).isSupported() : true).collect(Collectors.toList());
    }
}

