/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelPipedSink;

public class ChannelPipedOutputStream
extends OutputStream
implements Channel {
    private final ChannelPipedSink sink;
    private final byte[] b = new byte[1];
    private boolean closed;

    public ChannelPipedOutputStream(ChannelPipedSink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int i) throws IOException {
        byte[] byArray = this.b;
        synchronized (this.b) {
            this.b[0] = (byte)i;
            this.write(this.b, 0, 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen()) {
            throw new IOException("write(len=" + len + ") Stream has been closed");
        }
        this.sink.receive(b, off, len);
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            try {
                this.sink.eof();
            }
            finally {
                this.closed = true;
            }
        }
    }
}

