/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.channel;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

@FunctionalInterface
public interface RequestHandler<T> {
    public Result process(T var1, String var2, boolean var3, Buffer var4) throws Exception;

    public static enum Result {
        Unsupported,
        Replied,
        ReplySuccess,
        ReplyFailure;

        public static final Set<Result> VALUES;

        public static Result fromName(String name) {
            if (GenericUtils.isEmpty(name)) {
                return null;
            }
            for (Result r : VALUES) {
                if (!name.equalsIgnoreCase(r.name())) continue;
                return r;
            }
            return null;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(Result.class));
        }
    }
}

