/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.cipher;

import org.opendaylight.netconf.shaded.sshd.common.cipher.CipherInformation;
import org.opendaylight.netconf.shaded.sshd.common.util.NumberUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;

public interface Cipher
extends CipherInformation {
    public void init(Mode var1, byte[] var2, byte[] var3) throws Exception;

    default public void update(byte[] input) throws Exception {
        this.update(input, 0, NumberUtils.length(input));
    }

    public void update(byte[] var1, int var2, int var3) throws Exception;

    default public void updateAAD(byte[] data) throws Exception {
        this.updateAAD(data, 0, NumberUtils.length(data));
    }

    public void updateAAD(byte[] var1, int var2, int var3) throws Exception;

    default public void updateWithAAD(byte[] input, int offset, int aadLen, int inputLen) throws Exception {
        this.updateAAD(input, offset, aadLen);
        this.update(input, offset + aadLen, inputLen);
    }

    public static boolean checkSupported(String xform, int keyLength) {
        ValidateUtils.checkNotNullAndNotEmpty(xform, "No transformation");
        if (keyLength <= 0) {
            throw new IllegalArgumentException("Bad key length (" + keyLength + ") for cipher=" + xform);
        }
        try {
            int maxKeyLength = javax.crypto.Cipher.getMaxAllowedKeyLength(xform);
            return maxKeyLength >= keyLength;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum Mode {
        Encrypt,
        Decrypt;

    }
}

