/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys;

import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.SshPublicKey;

public class UnsupportedSshPublicKey
implements SshPublicKey {
    private static final long serialVersionUID = -4870624671501562706L;
    private final String keyType;
    private final byte[] keyData;

    public UnsupportedSshPublicKey(String keyType, byte[] keyData) {
        this.keyType = keyType;
        this.keyData = (byte[])keyData.clone();
    }

    @Override
    public String getAlgorithm() {
        return this.getKeyType();
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    public byte[] getKeyData() {
        return (byte[])this.keyData.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyData) * 31 + Objects.hash(this.keyType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnsupportedSshPublicKey)) {
            return false;
        }
        UnsupportedSshPublicKey other = (UnsupportedSshPublicKey)obj;
        return Arrays.equals(this.keyData, other.keyData) && Objects.equals(this.keyType, other.keyType);
    }
}

