/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.pem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.FilePasswordProvider;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Object;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Type;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.DERParser;
import org.opendaylight.netconf.shaded.sshd.common.util.io.input.NoCloseInputStream;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public class DSSPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN DSA PRIVATE KEY";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN DSA PRIVATE KEY"));
    public static final String END_MARKER = "END DSA PRIVATE KEY";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END DSA PRIVATE KEY"));
    public static final String DSS_OID = "1.2.840.10040.4.1";
    public static final DSSPEMResourceKeyPairParser INSTANCE = new DSSPEMResourceKeyPairParser();

    public DSSPEMResourceKeyPairParser() {
        super("DSA", DSS_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream, Map<String, String> headers) throws IOException, GeneralSecurityException {
        KeyPair kp = DSSPEMResourceKeyPairParser.decodeDSSKeyPair(SecurityUtils.getKeyFactory("DSA"), stream, false);
        return Collections.singletonList(kp);
    }

    public static KeyPair decodeDSSKeyPair(KeyFactory kf, InputStream s, boolean okToClose) throws IOException, GeneralSecurityException {
        ASN1Object sequence;
        try (DERParser parser = new DERParser(NoCloseInputStream.resolveInputStream(s, okToClose));){
            sequence = parser.readObject();
        }
        if (!ASN1Type.SEQUENCE.equals((Object)sequence.getObjType())) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)sequence.getObjType()));
        }
        parser = sequence.createParser();
        try {
            ASN1Object version = parser.readObject();
            if (version == null) {
                throw new StreamCorruptedException("No version");
            }
            BigInteger p = parser.readObject().asInteger();
            BigInteger q = parser.readObject().asInteger();
            BigInteger g = parser.readObject().asInteger();
            BigInteger y = parser.readObject().asInteger();
            BigInteger x = parser.readObject().asInteger();
            PublicKey pubKey = kf.generatePublic(new DSAPublicKeySpec(y, p, q, g));
            PrivateKey prvKey = kf.generatePrivate(new DSAPrivateKeySpec(x, p, q, g));
            KeyPair keyPair = new KeyPair(pubKey, prvKey);
            return keyPair;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

