/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.config.keys.u2f;

import java.util.Objects;
import org.opendaylight.netconf.shaded.eddsa.EdDSAPublicKey;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.u2f.SecurityKeyPublicKey;

public class SkED25519PublicKey
implements SecurityKeyPublicKey<EdDSAPublicKey> {
    public static final String ALGORITHM = "ED25519-SK";
    private static final long serialVersionUID = 4587115316266869640L;
    private final String appName;
    private final boolean noTouchRequired;
    private final EdDSAPublicKey delegatePublicKey;

    public SkED25519PublicKey(String appName, boolean noTouchRequired, EdDSAPublicKey delegatePublicKey) {
        this.appName = appName;
        this.noTouchRequired = noTouchRequired;
        this.delegatePublicKey = delegatePublicKey;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getKeyType() {
        return "sk-ssh-ed25519@openssh.com";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isNoTouchRequired() {
        return this.noTouchRequired;
    }

    @Override
    public EdDSAPublicKey getDelegatePublicKey() {
        return this.delegatePublicKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[appName=" + this.getAppName() + ", noTouchRequired=" + this.isNoTouchRequired() + ", delegatePublicKey=" + this.getDelegatePublicKey() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.noTouchRequired, this.delegatePublicKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkED25519PublicKey other = (SkED25519PublicKey)obj;
        return Objects.equals(this.appName, other.appName) && this.noTouchRequired == other.noTouchRequired && Objects.equals(this.delegatePublicKey, other.delegatePublicKey);
    }
}

