/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.digest;

import java.security.MessageDigest;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.digest.Digest;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.NumberUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public class BaseDigest
implements Digest {
    private final String algorithm;
    private final int bsize;
    private int h;
    private String s;
    private MessageDigest md;

    public BaseDigest(String algorithm, int bsize) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(algorithm, "No algorithm");
        ValidateUtils.checkTrue(bsize > 0, "Invalid block size: %d", bsize);
        this.bsize = bsize;
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBlockSize() {
        return this.bsize;
    }

    @Override
    public void init() throws Exception {
        this.md = SecurityUtils.getMessageDigest(this.getAlgorithm());
    }

    @Override
    public void update(byte[] data) throws Exception {
        this.update(data, 0, NumberUtils.length(data));
    }

    @Override
    public void update(byte[] data, int start, int len) throws Exception {
        Objects.requireNonNull(this.md, "Digest not initialized").update(data, start, len);
    }

    protected MessageDigest getMessageDigest() {
        return this.md;
    }

    @Override
    public byte[] digest() throws Exception {
        return Objects.requireNonNull(this.md, "Digest not initialized").digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        BaseDigest baseDigest = this;
        synchronized (baseDigest) {
            if (this.h == 0) {
                this.h = Objects.hashCode(this.getAlgorithm()) + this.getBlockSize();
                if (this.h == 0) {
                    this.h = 1;
                }
            }
        }
        return this.h;
    }

    @Override
    public int compareTo(Digest that) {
        String thatAlg;
        if (that == null) {
            return -1;
        }
        if (this == that) {
            return 0;
        }
        String thisAlg = this.getAlgorithm();
        int nRes = GenericUtils.safeCompare(thisAlg, thatAlg = that.getAlgorithm(), false);
        if (nRes != 0) {
            return nRes;
        }
        nRes = Integer.compare(this.getBlockSize(), that.getBlockSize());
        if (nRes != 0) {
            return nRes;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        int nRes = this.compareTo((Digest)obj);
        return nRes == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseDigest baseDigest = this;
        synchronized (baseDigest) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + ":" + this.getBlockSize() + "]";
            }
        }
        return this.s;
    }
}

