/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.file.nativefs;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.opendaylight.netconf.shaded.sshd.common.file.FileSystemFactory;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.OsUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;

public class NativeFileSystemFactory
extends AbstractLoggingBean
implements FileSystemFactory {
    public static final String DEFAULT_USERS_HOME = OsUtils.isWin32() ? "C:\\Users" : (OsUtils.isOSX() ? "/Users" : "/home");
    public static final NativeFileSystemFactory INSTANCE = new NativeFileSystemFactory();
    private boolean createHome;
    private String usersHomeDir = DEFAULT_USERS_HOME;

    public NativeFileSystemFactory() {
        this(false);
    }

    public NativeFileSystemFactory(boolean createHome) {
        this.createHome = createHome;
    }

    public String getUsersHomeDir() {
        return this.usersHomeDir;
    }

    public void setUsersHomeDir(String usersHomeDir) {
        this.usersHomeDir = ValidateUtils.hasContent(usersHomeDir, "No users home dir");
    }

    public boolean isCreateHome() {
        return this.createHome;
    }

    public void setCreateHome(boolean createHome) {
        this.createHome = createHome;
    }

    @Override
    public Path getUserHomeDir(SessionContext session) throws IOException {
        String userName = session.getUsername();
        if (GenericUtils.isEmpty(userName)) {
            return null;
        }
        String homeRoot = this.getUsersHomeDir();
        if (GenericUtils.isEmpty(homeRoot)) {
            return null;
        }
        return Paths.get(homeRoot, userName).normalize().toAbsolutePath();
    }

    @Override
    public FileSystem createFileSystem(SessionContext session) throws IOException {
        if (this.isCreateHome()) {
            Path homeDir = this.getUserHomeDir(session);
            if (homeDir == null) {
                throw new InvalidPathException(session.getUsername(), "Cannot resolve home directory");
            }
            if (Files.exists(homeDir, new LinkOption[0])) {
                if (!Files.isDirectory(homeDir, new LinkOption[0])) {
                    throw new NotDirectoryException(homeDir.toString());
                }
            } else {
                Path p = Files.createDirectories(homeDir, new FileAttribute[0]);
                this.log.info("createFileSystem({}) created {}", (Object)session, (Object)p);
            }
        }
        return FileSystems.getDefault();
    }
}

