/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.file.root;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.opendaylight.netconf.shaded.sshd.common.file.root.RootedDirectoryStream;
import org.opendaylight.netconf.shaded.sshd.common.file.root.RootedFileSystem;
import org.opendaylight.netconf.shaded.sshd.common.file.root.RootedFileSystemUtils;
import org.opendaylight.netconf.shaded.sshd.common.file.root.RootedPath;
import org.opendaylight.netconf.shaded.sshd.common.file.root.RootedSecureDirectoryStream;
import org.opendaylight.netconf.shaded.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootedFileSystemProvider
extends FileSystemProvider {
    protected final Logger log;
    private final Map<Path, RootedFileSystem> fileSystems = new HashMap<Path, RootedFileSystem>();

    public RootedFileSystemProvider() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public String getScheme() {
        return "root";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        return this.newFileSystem(uri, this.uriToPath(uri), env);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.getFileSystem(this.uriToPath(uri));
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        return this.newFileSystem(path, path, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem newFileSystem(Object src, Path path, Map<String, ?> env) throws IOException {
        Path root = RootedFileSystemProvider.ensureDirectory(path).toRealPath(new LinkOption[0]);
        RootedFileSystem rootedFs = null;
        Map<Path, RootedFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (!this.fileSystems.containsKey(root)) {
                rootedFs = new RootedFileSystem(this, path, env);
                this.fileSystems.put(root, rootedFs);
            }
        }
        if (rootedFs == null) {
            throw new FileSystemAlreadyExistsException("newFileSystem(" + src + ") already mapped " + root);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newFileSystem({}): {}", src, (Object)rootedFs);
        }
        return rootedFs;
    }

    protected Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        String expected = this.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException("URI scheme (" + scheme + ") is not '" + expected + "'");
        }
        String root = uri.getRawSchemeSpecificPart();
        int i = root.indexOf("!/");
        if (i != -1) {
            root = root.substring(0, i);
        }
        try {
            return Paths.get(new URI(root)).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(root + ": " + e.getMessage(), e);
        }
    }

    private static Path ensureDirectory(Path path) {
        return IoUtils.ensureDirectory(path, IoUtils.getLinkOptions(true));
    }

    @Override
    public Path getPath(URI uri) {
        String str = uri.getSchemeSpecificPart();
        int i = str.indexOf("!/");
        if (i == -1) {
            throw new IllegalArgumentException("URI: " + uri + " does not contain path info - e.g., root:file://foo/bar!/");
        }
        FileSystem fs = this.getFileSystem(uri);
        String subPath = str.substring(i + 1);
        Path p = fs.getPath(subPath, new String[0]);
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPath({}): {}", (Object)uri, (Object)p);
        }
        return p;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newInputStream(r, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newOutputStream(r, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newFileChannel(r, options, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newAsynchronousFileChannel(r, options, executor, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.newByteChannel(r, options, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        try {
            return this.root((RootedFileSystem)((RootedPath)dir).getFileSystem(), p.newDirectoryStream(r, filter));
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, dir);
        }
    }

    protected DirectoryStream<Path> root(RootedFileSystem rfs, DirectoryStream<Path> ds) {
        if (ds instanceof SecureDirectoryStream) {
            return new RootedSecureDirectoryStream(rfs, (SecureDirectoryStream)ds);
        }
        return new RootedDirectoryStream(rfs, ds);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path r = this.unroot(dir);
        FileSystemProvider p = this.provider(r);
        try {
            p.createDirectory(r, attrs);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, dir);
        }
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        RootedFileSystemUtils.validateSafeRelativeSymlink(target);
        Path l = this.unroot(link);
        Path t = target.isAbsolute() ? this.unroot(target) : l.getFileSystem().getPath(target.toString(), new String[0]);
        FileSystemProvider p = this.provider(l);
        try {
            p.createSymbolicLink(l, t, attrs);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSymbolicLink({} => {}", (Object)l, (Object)t);
            }
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        Path l = this.unroot(link);
        Path t = this.unroot(existing);
        try {
            this.provider(l).createLink(l, t);
            if (this.log.isDebugEnabled()) {
                this.log.debug("createLink({} => {}", (Object)l, (Object)t);
            }
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void delete(Path path) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("delete({}): {}", (Object)path, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        try {
            p.delete(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("deleteIfExists({}): {}", (Object)path, (Object)r);
        }
        FileSystemProvider p = this.provider(r);
        try {
            return p.deleteIfExists(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        Path r = this.unroot(link);
        FileSystemProvider p = this.provider(r);
        try {
            Path t = p.readSymbolicLink(r);
            Path target = this.root((RootedFileSystem)link.getFileSystem(), t);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readSymbolicLink({})[{}]: {}[{}]", new Object[]{link, r, target, t});
            }
            return target;
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, link);
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        Path s = this.unroot(source);
        Path t = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("copy({})[{}]: {}[{}]", new Object[]{source, s, target, t});
        }
        FileSystemProvider p = this.provider(s);
        try {
            p.copy(s, t, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, source);
        }
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        Path s = this.unroot(source);
        Path t = this.unroot(target);
        if (this.log.isTraceEnabled()) {
            this.log.trace("move({})[{}]: {}[{}]", new Object[]{source, s, target, t});
        }
        FileSystemProvider p = this.provider(s);
        try {
            p.move(s, t, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, source);
        }
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        Path r = this.unroot(path);
        Path r2 = this.unroot(path2);
        FileSystemProvider p = this.provider(r);
        try {
            return p.isSameFile(r, r2);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            return p.isHidden(r);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        RootedFileSystem fileSystem = this.getFileSystem(path);
        Path root = fileSystem.getRoot();
        try {
            return Files.getFileStore(root);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootedFileSystem getFileSystem(Path path) throws FileSystemNotFoundException {
        Path real = this.unroot(path);
        Path rootInstance = null;
        RootedFileSystem fsInstance = null;
        Map<Path, RootedFileSystem> map = this.fileSystems;
        synchronized (map) {
            for (Map.Entry<Path, RootedFileSystem> fse : this.fileSystems.entrySet()) {
                Path root = fse.getKey();
                RootedFileSystem fs = fse.getValue();
                if (real.equals(root)) {
                    return fs;
                }
                if (!real.startsWith(root) || rootInstance != null && rootInstance.getNameCount() >= root.getNameCount()) continue;
                rootInstance = root;
                fsInstance = fs;
            }
        }
        if (fsInstance == null) {
            throw new FileSystemNotFoundException(path.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getFileSystem({}): {}", (Object)path, fsInstance);
        }
        return fsInstance;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            p.checkAccess(r, modes);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        return p.getFileAttributeView(r, type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("readAttributes({})[{}] type={}", new Object[]{path, r, type.getSimpleName()});
        }
        FileSystemProvider p = this.provider(r);
        try {
            return p.readAttributes(r, type, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        FileSystemProvider p = this.provider(r);
        try {
            Map<String, Object> attrs = p.readAttributes(r, attributes, options);
            if (this.log.isTraceEnabled()) {
                this.log.trace("readAttributes({})[{}] {}: {}", new Object[]{path, r, attributes, attrs});
            }
            return attrs;
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Path r = this.unroot(path);
        if (this.log.isTraceEnabled()) {
            this.log.trace("setAttribute({})[{}] {}={}", new Object[]{path, r, attribute, value});
        }
        FileSystemProvider p = this.provider(r);
        try {
            p.setAttribute(r, attribute, value, options);
        }
        catch (IOException ex) {
            throw this.translateIoException(ex, path);
        }
    }

    protected FileSystemProvider provider(Path path) {
        FileSystem fs = path.getFileSystem();
        return fs.provider();
    }

    protected Path root(RootedFileSystem rfs, Path nat) {
        if (nat.isAbsolute()) {
            if (nat.startsWith(rfs.getRoot())) {
                if (nat.getNameCount() == rfs.getRoot().getNameCount()) {
                    return rfs.getPath("/", new String[0]);
                }
                String firstName = "/" + nat.getName(rfs.getRoot().getNameCount());
                String[] varargs = new String[nat.getNameCount() - rfs.getRoot().getNameCount() - 1];
                int varargsCounter = 0;
                for (int i = 1 + rfs.getRoot().getNameCount(); i < nat.getNameCount(); ++i) {
                    varargs[varargsCounter++] = nat.getName(i).toString();
                }
                return rfs.getPath(firstName, varargs);
            }
            Path root = rfs.getRoot();
            Path rel = root.relativize(nat);
            return rfs.getPath("/" + rel, new String[0]);
        }
        return rfs.getPath(nat.toString(), new String[0]);
    }

    protected Path unroot(Path path) {
        Objects.requireNonNull(path, "No path to unroot");
        if (!(path instanceof RootedPath)) {
            throw new ProviderMismatchException("unroot(" + path + ") is not a " + RootedPath.class.getSimpleName() + " but rather a " + path.getClass().getSimpleName());
        }
        return this.resolveLocalPath((RootedPath)path);
    }

    protected Path resolveLocalPath(RootedPath path) {
        Objects.requireNonNull(path, "No rooted path to resolve");
        RootedFileSystem rfs = (RootedFileSystem)path.getFileSystem();
        Path root = rfs.getRoot();
        Path resolved = IoUtils.chroot(root, path);
        if (!resolved.normalize().startsWith(root)) {
            throw new InvalidPathException(root.toString(), "Not under root");
        }
        return resolved;
    }

    private IOException translateIoException(IOException ex, Path rootedPath) {
        RootedPath rootedPathCasted = (RootedPath)rootedPath;
        Path root = ((RootedFileSystem)rootedPathCasted.getFileSystem()).getRoot();
        if (ex instanceof FileSystemException) {
            String file = this.fixExceptionFileName(root, rootedPath, ((FileSystemException)ex).getFile());
            String otherFile = this.fixExceptionFileName(root, rootedPath, ((FileSystemException)ex).getOtherFile());
            String reason = ((FileSystemException)ex).getReason();
            if (NoSuchFileException.class.equals(ex.getClass())) {
                return new NoSuchFileException(file, otherFile, reason);
            }
            if (FileSystemLoopException.class.equals(ex.getClass())) {
                return new FileSystemLoopException(file);
            }
            if (NotDirectoryException.class.equals(ex.getClass())) {
                return new NotDirectoryException(file);
            }
            if (DirectoryNotEmptyException.class.equals(ex.getClass())) {
                return new DirectoryNotEmptyException(file);
            }
            if (NotLinkException.class.equals(ex.getClass())) {
                return new NotLinkException(file);
            }
            if (AtomicMoveNotSupportedException.class.equals(ex.getClass())) {
                return new AtomicMoveNotSupportedException(file, otherFile, reason);
            }
            if (FileAlreadyExistsException.class.equals(ex.getClass())) {
                return new FileAlreadyExistsException(file, otherFile, reason);
            }
            if (AccessDeniedException.class.equals(ex.getClass())) {
                return new AccessDeniedException(file, otherFile, reason);
            }
            return new FileSystemException(file, otherFile, reason);
        }
        if (ex.getClass().equals(FileNotFoundException.class)) {
            return new FileNotFoundException(ex.getLocalizedMessage().replace(root.toString(), ""));
        }
        return ex;
    }

    private String fixExceptionFileName(Path root, Path rootedPath, String fileName) {
        if (fileName == null) {
            return null;
        }
        Path toFix = root.getFileSystem().getPath(fileName, new String[0]);
        if (toFix.getNameCount() == root.getNameCount()) {
            return rootedPath.getFileSystem().getSeparator();
        }
        StringBuilder ret = new StringBuilder();
        for (int partNum = root.getNameCount(); partNum < toFix.getNameCount(); ++partNum) {
            ret.append(rootedPath.getFileSystem().getSeparator());
            ret.append(toFix.getName(partNum++));
        }
        return ret.toString();
    }
}

