/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.io;

import java.io.IOException;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.future.CancelOption;
import org.opendaylight.netconf.shaded.sshd.common.future.DefaultVerifiableSshFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.IoWriteFuture;

public abstract class AbstractIoWriteFuture
extends DefaultVerifiableSshFuture<IoWriteFuture>
implements IoWriteFuture {
    protected AbstractIoWriteFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public IoWriteFuture verify(long timeout, CancelOption ... options) throws IOException {
        Boolean result = this.verifyResult(Boolean.class, timeout, new CancelOption[0]);
        if (!result.booleanValue()) {
            throw this.formatExceptionMessage(SshException::new, "Write failed signalled while wait %d msec.", timeout);
        }
        return this;
    }

    @Override
    public boolean isWritten() {
        Object value = this.getValue();
        return value instanceof Boolean && (Boolean)value != false;
    }

    @Override
    public Throwable getException() {
        Object v = this.getValue();
        if (v instanceof Throwable) {
            return (Throwable)v;
        }
        return null;
    }

    public static IoWriteFuture fulfilled(Object id, Object value) {
        AbstractIoWriteFuture result = new AbstractIoWriteFuture(id, null){};
        result.setValue(Objects.requireNonNull(value));
        return result;
    }
}

