/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.kex;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.opendaylight.netconf.shaded.sshd.common.Factory;
import org.opendaylight.netconf.shaded.sshd.common.digest.Digest;
import org.opendaylight.netconf.shaded.sshd.common.kex.AbstractDH;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public class DHG
extends AbstractDH {
    public static final String KEX_TYPE = "DH";
    private BigInteger p;
    private BigInteger g;
    private BigInteger f;
    private Factory<? extends Digest> factory;

    public DHG(Factory<? extends Digest> digestFactory) throws Exception {
        this(digestFactory, null, null);
    }

    public DHG(Factory<? extends Digest> digestFactory, BigInteger pValue, BigInteger gValue) throws Exception {
        this.myKeyAgree = SecurityUtils.getKeyAgreement(KEX_TYPE);
        this.factory = digestFactory;
        this.p = pValue;
        this.g = gValue;
    }

    @Override
    protected byte[] calculateE() throws Exception {
        DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
        KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator(KEX_TYPE);
        myKpairGen.initialize(dhSkipParamSpec);
        KeyPair myKpair = myKpairGen.generateKeyPair();
        this.myKeyAgree.init(myKpair.getPrivate());
        DHPublicKey pubKey = (DHPublicKey)myKpair.getPublic();
        BigInteger e = pubKey.getY();
        return e.toByteArray();
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        DHPublicKeySpec keySpec = new DHPublicKeySpec(this.f, this.p, this.g);
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory(KEX_TYPE);
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return DHG.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setP(byte[] p) {
        this.setP(new BigInteger(p));
    }

    public void setG(byte[] g) {
        this.setG(new BigInteger(g));
    }

    @Override
    public void setF(byte[] f) {
        this.setF(new BigInteger(f));
    }

    public BigInteger getP() {
        return this.p;
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public void setF(BigInteger f) {
        this.f = Objects.requireNonNull(f, "No 'f' value specified");
    }

    @Override
    public Digest getHash() throws Exception {
        return this.factory.create();
    }

    @Override
    public String toString() {
        return super.toString() + "[p=" + this.p + ", g=" + this.g + ", f=" + this.f + ", digest=" + this.factory + "]";
    }
}

