/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.kex.extension.parser;

import java.io.IOException;
import org.opendaylight.netconf.shaded.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.opendaylight.netconf.shaded.sshd.common.kex.extension.parser.DelayedCompressionAlgorithms;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.BufferUtils;

public class DelayCompression
extends AbstractKexExtensionParser<DelayedCompressionAlgorithms> {
    public static final String NAME = "delay-compression";
    public static final DelayCompression INSTANCE = new DelayCompression();

    public DelayCompression() {
        super(NAME);
    }

    @Override
    public DelayedCompressionAlgorithms parseExtension(Buffer buffer) throws IOException {
        DelayedCompressionAlgorithms algos = new DelayedCompressionAlgorithms();
        algos.setClient2Server(buffer.getNameList());
        algos.setServer2Client(buffer.getNameList());
        return algos;
    }

    @Override
    protected void encode(DelayedCompressionAlgorithms algos, Buffer buffer) throws IOException {
        int lenPos = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putNameList(algos.getClient2Server());
        buffer.putNameList(algos.getServer2Client());
        BufferUtils.updateLengthPlaceholder(buffer, lenPos);
    }
}

