/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.kex.extension.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.netconf.shaded.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;

public class ServerSignatureAlgorithms
extends AbstractKexExtensionParser<List<String>> {
    public static final String NAME = "server-sig-algs";
    public static final ServerSignatureAlgorithms INSTANCE = new ServerSignatureAlgorithms();

    public ServerSignatureAlgorithms() {
        super(NAME);
    }

    @Override
    public List<String> parseExtension(byte[] data, int off, int len) throws IOException {
        String s = len <= 0 ? "" : new String(data, off, len, StandardCharsets.UTF_8);
        String[] vals = GenericUtils.isEmpty(s) ? GenericUtils.EMPTY_STRING_ARRAY : GenericUtils.split(s, ',');
        return GenericUtils.isEmpty(vals) ? Collections.emptyList() : Arrays.asList(vals);
    }

    @Override
    public List<String> parseExtension(Buffer buffer) throws IOException {
        return this.parseExtension(buffer.array(), buffer.rpos(), buffer.available());
    }

    @Override
    protected void encode(List<String> names, Buffer buffer) throws IOException {
        buffer.putNameList(names);
    }
}

