/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.session;

import java.util.Map;
import org.opendaylight.netconf.shaded.sshd.common.AttributeStore;
import org.opendaylight.netconf.shaded.sshd.common.Closeable;
import org.opendaylight.netconf.shaded.sshd.common.auth.UsernameHolder;
import org.opendaylight.netconf.shaded.sshd.common.cipher.CipherInformation;
import org.opendaylight.netconf.shaded.sshd.common.compression.CompressionInformation;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexProposalOption;
import org.opendaylight.netconf.shaded.sshd.common.kex.KexState;
import org.opendaylight.netconf.shaded.sshd.common.mac.MacInformation;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionHeartbeatController;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.net.ConnectionEndpointsIndicator;

public interface SessionContext
extends ConnectionEndpointsIndicator,
UsernameHolder,
SessionHeartbeatController,
AttributeStore,
Closeable {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String FALLBACK_SSH_VERSION_PREFIX = "SSH-1.99-";
    public static final int MAX_VERSION_LINE_LENGTH = 256;

    public byte[] getSessionId();

    public boolean isServerSession();

    public String getClientVersion();

    public Map<KexProposalOption, String> getClientKexProposals();

    public String getServerVersion();

    public Map<KexProposalOption, String> getServerKexProposals();

    public KexState getKexState();

    public Map<KexProposalOption, String> getKexNegotiationResult();

    public String getNegotiatedKexParameter(KexProposalOption var1);

    public CipherInformation getCipherInformation(boolean var1);

    public CompressionInformation getCompressionInformation(boolean var1);

    public MacInformation getMacInformation(boolean var1);

    public boolean isAuthenticated();

    public static boolean isValidVersionPrefix(String version) {
        return GenericUtils.isNotEmpty(version) && (version.startsWith(DEFAULT_SSH_VERSION_PREFIX) || version.startsWith(FALLBACK_SSH_VERSION_PREFIX));
    }

    public static boolean isSecureSessionTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        for (KexProposalOption opt : KexProposalOption.CIPHER_PROPOSALS) {
            String value = session.getNegotiatedKexParameter(opt);
            if (!GenericUtils.isEmpty(value) && !"none".equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDataIntegrityTransport(SessionContext session) {
        if (session == null) {
            return false;
        }
        for (KexProposalOption opt : KexProposalOption.MAC_PROPOSALS) {
            String value = session.getNegotiatedKexParameter(opt);
            if (!GenericUtils.isEmpty(value)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSessionPayloadSize(long value) {
        return value >= 0L && value < 0x7FFFFFF2L;
    }

    public static long validateSessionPayloadSize(long value, String format) {
        ValidateUtils.checkTrue(SessionContext.isValidSessionPayloadSize(value), format, value);
        return value;
    }
}

