/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.session.helpers;

import java.io.IOException;
import org.opendaylight.netconf.shaded.sshd.common.PropertyResolver;
import org.opendaylight.netconf.shaded.sshd.common.SshConstants;
import org.opendaylight.netconf.shaded.sshd.common.channel.Channel;
import org.opendaylight.netconf.shaded.sshd.common.io.IoWriteFuture;
import org.opendaylight.netconf.shaded.sshd.common.session.ConnectionService;
import org.opendaylight.netconf.shaded.sshd.common.session.UnknownChannelReferenceHandler;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.core.CoreModuleProperties;

public class DefaultUnknownChannelReferenceHandler
extends AbstractLoggingBean
implements UnknownChannelReferenceHandler {
    public static final DefaultUnknownChannelReferenceHandler INSTANCE = new DefaultUnknownChannelReferenceHandler();

    @Override
    public Channel handleUnknownChannelCommand(ConnectionService service, byte cmd, long channelId, Buffer buffer) throws IOException {
        Object session = service.getSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleUnknownChannelCommand({}) received {} command for unknown channel: {}", new Object[]{session, SshConstants.getCommandMessageName(cmd), channelId});
        }
        boolean wantReply = false;
        switch (cmd) {
            case 98: {
                String req = buffer.getString();
                wantReply = buffer.getBoolean();
                if (!debugEnabled) break;
                this.log.debug("handleUnknownChannelCommand({}) Received SSH_MSG_CHANNEL_REQUEST={} (wantReply={}) for unknown channel: {}", new Object[]{session, req, wantReply, channelId});
                break;
            }
            case 94: 
            case 95: {
                wantReply = CoreModuleProperties.SEND_REPLY_FOR_CHANNEL_DATA.getRequired((PropertyResolver)session);
                if (!this.log.isTraceEnabled()) break;
                this.log.trace("handleUnknownChannelCommand({}) received msg channel data (opcode={}) reply={}", new Object[]{session, cmd, wantReply});
                break;
            }
        }
        if (wantReply) {
            this.sendFailureResponse(service, cmd, channelId);
        }
        return null;
    }

    protected IoWriteFuture sendFailureResponse(ConnectionService service, byte cmd, long channelId) throws IOException {
        Object session = service.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendFailureResponse({}) send SSH_MSG_CHANNEL_FAILURE for {} command on unknown channel: {}", new Object[]{session, SshConstants.getCommandMessageName(cmd), channelId});
        }
        Buffer rsp = session.createBuffer((byte)100, 4);
        rsp.putUInt(channelId);
        return session.writePacket(rsp);
    }
}

