/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.VersionInfo;

public final class OsUtils {
    public static final String CURRENT_USER_OVERRIDE_PROP = "org.opendaylight.netconf.shaded.sshd.currentUser";
    public static final String JAVA_VERSION_OVERRIDE_PROP = "org.opendaylight.netconf.shaded.sshd.javaVersion";
    public static final String OS_TYPE_OVERRIDE_PROP = "org.opendaylight.netconf.shaded.sshd.osType";
    public static final String ANDROID_MODE_OVERRIDE_PROP = "org.opendaylight.netconf.shaded.sshd.androidMode";
    public static final String DALVIK_MACHINE_OVERRIDE_PROP = "org.opendaylight.netconf.shaded.sshd.dalvikMachine";
    public static final String WINDOWS_SHELL_COMMAND_NAME = "cmd.exe";
    public static final String LINUX_SHELL_COMMAND_NAME = "/bin/sh";
    public static final String ROOT_USER = "root";
    public static final List<String> LINUX_COMMAND = Collections.unmodifiableList(Arrays.asList("/bin/sh", "-i", "-l"));
    public static final List<String> WINDOWS_COMMAND = Collections.unmodifiableList(Collections.singletonList("cmd.exe"));
    public static final List<String> ANDROID_DETECTION_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.vendor", "java.specification.vendor", "java.vm.vendor", "java.vm.specification.vendor"));
    public static final Predicate<String> ANDROID_PROPERTY_VALUE_MATCHER = v -> GenericUtils.trimToEmpty(v).toLowerCase().contains("android");
    public static final List<String> DALVIK_DETECTION_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.specification.name", "java.vm.name", "java.vm.specification.name"));
    public static final Predicate<String> DALVIK_PROPERTY_VALUE_MATCHER = v -> GenericUtils.trimToEmpty(v).toLowerCase().contains("dalvik");
    private static final AtomicReference<String> CURRENT_USER_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<VersionInfo> JAVA_VERSION_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<String> OS_TYPE_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<Boolean> ANDROID_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<Boolean> DALVIK_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<Supplier<? extends Path>> CWD_PROVIDER_HOLDER = new AtomicReference();

    private OsUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isAndroid() {
        return OsUtils.resolveAndroidSettingFlag(ANDROID_HOLDER, ANDROID_MODE_OVERRIDE_PROP, ANDROID_DETECTION_PROPERTIES, ANDROID_PROPERTY_VALUE_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAndroid(Boolean value) {
        AtomicReference<Boolean> atomicReference = ANDROID_HOLDER;
        synchronized (atomicReference) {
            ANDROID_HOLDER.set(value);
        }
    }

    public static boolean isDalvikMachine() {
        return OsUtils.resolveAndroidSettingFlag(DALVIK_HOLDER, DALVIK_MACHINE_OVERRIDE_PROP, DALVIK_DETECTION_PROPERTIES, DALVIK_PROPERTY_VALUE_MATCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDalvikMachine(Boolean value) {
        AtomicReference<Boolean> atomicReference = DALVIK_HOLDER;
        synchronized (atomicReference) {
            DALVIK_HOLDER.set(value);
        }
    }

    public static boolean isUNIX() {
        return !OsUtils.isWin32() && !OsUtils.isOSX();
    }

    public static boolean isOSX() {
        return OsUtils.getOS().contains("mac");
    }

    public static boolean isWin32() {
        return OsUtils.getOS().contains("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOS(String os) {
        AtomicReference<String> atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            OS_TYPE_HOLDER.set(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean resolveAndroidSettingFlag(AtomicReference<Boolean> flagHolder, String overrideProp, Collection<String> detectionProps, Predicate<? super String> detector) {
        AtomicReference<Boolean> atomicReference = flagHolder;
        synchronized (atomicReference) {
            Boolean value = flagHolder.get();
            if (value != null) {
                return value;
            }
            String propValue = System.getProperty(overrideProp);
            if (detector.test(propValue)) {
                flagHolder.set(Boolean.TRUE);
                return true;
            }
            for (String p : detectionProps) {
                String detectionPropValue = System.getProperty(p);
                if (!detector.test(detectionPropValue)) continue;
                flagHolder.set(Boolean.TRUE);
                return true;
            }
            flagHolder.set(Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOS() {
        String typeValue;
        AtomicReference<String> atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            typeValue = OS_TYPE_HOLDER.get();
            if (typeValue != null) {
                return typeValue;
            }
            String value = System.getProperty(OS_TYPE_OVERRIDE_PROP, System.getProperty("os.name"));
            typeValue = GenericUtils.trimToEmpty(value).toLowerCase();
            OS_TYPE_HOLDER.set(typeValue);
        }
        return typeValue;
    }

    public static String resolveDefaultInteractiveShellCommand() {
        return OsUtils.resolveDefaultInteractiveShellCommand(OsUtils.isWin32());
    }

    public static String resolveDefaultInteractiveShellCommand(boolean winOS) {
        return winOS ? WINDOWS_SHELL_COMMAND_NAME : "/bin/sh -i -l";
    }

    public static List<String> resolveDefaultInteractiveCommandElements() {
        return OsUtils.resolveDefaultInteractiveCommandElements(OsUtils.isWin32());
    }

    public static List<String> resolveDefaultInteractiveCommandElements(boolean winOS) {
        if (winOS) {
            return WINDOWS_COMMAND;
        }
        return LINUX_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getCurrentWorkingDirectory() {
        Supplier<? extends Path> cwdProvider;
        AtomicReference<Supplier<? extends Path>> atomicReference = CWD_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            cwdProvider = CWD_PROVIDER_HOLDER.get();
        }
        if (cwdProvider != null) {
            return cwdProvider.get();
        }
        String cwdLocal = System.getProperty("user.dir");
        return GenericUtils.isBlank(cwdLocal) ? null : Paths.get(cwdLocal, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentWorkingDirectoryResolver(Supplier<? extends Path> cwdProvider) {
        AtomicReference<Supplier<? extends Path>> atomicReference = CWD_PROVIDER_HOLDER;
        synchronized (atomicReference) {
            CWD_PROVIDER_HOLDER.set(cwdProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUser() {
        String username;
        AtomicReference<String> atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            username = CURRENT_USER_HOLDER.get();
            if (username != null) {
                return username;
            }
            username = OsUtils.getCanonicalUser(System.getProperty(CURRENT_USER_OVERRIDE_PROP, System.getProperty("user.name")));
            ValidateUtils.hasContent(username, "No username available");
            CURRENT_USER_HOLDER.set(username);
        }
        return username;
    }

    public static String getCanonicalUser(String user) {
        if (GenericUtils.isEmpty(user)) {
            return user;
        }
        if (OsUtils.isWin32()) {
            int pos = user.lastIndexOf(92);
            if (pos > 0) {
                user = user.substring(pos + 1);
            }
            if ((pos = user.indexOf(32)) > 0) {
                user = user.substring(0, pos).trim();
            }
        }
        return user;
    }

    public static String resolveCanonicalGroup(String group, String user) {
        if (OsUtils.isUNIX()) {
            return group;
        }
        if (GenericUtils.isEmpty(group)) {
            int pos = GenericUtils.isEmpty(user) ? -1 : user.lastIndexOf(92);
            return pos > 0 ? user.substring(0, pos) : group;
        }
        int pos = group.indexOf(32);
        return pos < 0 ? group : group.substring(0, pos).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentUser(String username) {
        AtomicReference<String> atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            CURRENT_USER_HOLDER.set(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo getJavaVersion() {
        VersionInfo version;
        AtomicReference<VersionInfo> atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            version = JAVA_VERSION_HOLDER.get();
            if (version != null) {
                return version;
            }
            String value = System.getProperty(JAVA_VERSION_OVERRIDE_PROP, System.getProperty("java.version"));
            value = ValidateUtils.checkNotNullAndNotEmpty(value, "No configured Java version value").replace('_', '.');
            for (int index = 0; index < value.length(); ++index) {
                char ch = value.charAt(index);
                if (ch == '.' || ch >= '0' && ch <= '9') continue;
                value = value.substring(0, index);
                break;
            }
            version = ValidateUtils.checkNotNull(VersionInfo.parse(value), "No version parsed for %s", (Object)value);
            JAVA_VERSION_HOLDER.set(version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJavaVersion(VersionInfo version) {
        AtomicReference<VersionInfo> atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            JAVA_VERSION_HOLDER.set(version);
        }
    }

    public static String getComparablePath(String path) {
        String p = path == null ? "" : path;
        return OsUtils.isWin32() ? p.toLowerCase() : p;
    }
}

