/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class DSSBufferPublicKeyParser
extends AbstractBufferPublicKeyParser<DSAPublicKey> {
    public static final DSSBufferPublicKeyParser INSTANCE = new DSSBufferPublicKeyParser();

    public DSSBufferPublicKeyParser() {
        super(DSAPublicKey.class, "ssh-dss");
    }

    @Override
    public DSAPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        BigInteger p = buffer.getMPInt();
        BigInteger q = buffer.getMPInt();
        BigInteger g = buffer.getMPInt();
        BigInteger y = buffer.getMPInt();
        return (DSAPublicKey)this.generatePublicKey("DSA", new DSAPublicKeySpec(y, p, q, g));
    }
}

