/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.helper.LazyMatchingTypeIterator;

public class LazyMatchingTypeIterable<T>
implements Iterable<T> {
    private final Iterable<?> values;
    private final Class<T> type;

    public LazyMatchingTypeIterable(Iterable<?> values, Class<T> type) {
        this.values = values;
        this.type = Objects.requireNonNull(type, "No type selector specified");
    }

    public Iterable<?> getValues() {
        return this.values;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Iterator<T> iterator() {
        Iterable<?> vals = this.getValues();
        if (vals == null) {
            return Collections.emptyIterator();
        }
        return LazyMatchingTypeIterator.lazySelectMatchingTypes(vals.iterator(), this.getType());
    }

    public String toString() {
        Class<T> t = this.getType();
        return Iterable.class.getSimpleName() + "[lazy-select](" + t.getSimpleName() + ")";
    }

    public static <T> Iterable<T> lazySelectMatchingTypes(Iterable<?> values, Class<T> type) {
        Objects.requireNonNull(type, "No type selector specified");
        return values == null ? Collections.emptyList() : new LazyMatchingTypeIterable<T>(values, type);
    }
}

