/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.OsUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.FileSnapshot;
import org.opendaylight.netconf.shaded.sshd.common.util.io.IoUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.io.resource.PathResource;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;

public class ModifiableFileWatcher
extends AbstractLoggingBean {
    public static final Set<PosixFilePermission> STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE));
    protected final LinkOption[] options;
    private final Path file;
    private final AtomicReference<FileSnapshot> metadata = new AtomicReference();

    public ModifiableFileWatcher(Path file) {
        this(file, IoUtils.getLinkOptions(true));
    }

    public ModifiableFileWatcher(Path file, LinkOption ... options) {
        this.file = Objects.requireNonNull(file, "No path to watch");
        this.options = options == null ? IoUtils.EMPTY_LINK_OPTIONS : (LinkOption[])options.clone();
    }

    public final Path getPath() {
        return this.file;
    }

    public final boolean exists() throws IOException {
        return Files.exists(this.getPath(), this.options);
    }

    public final long size() throws IOException {
        if (this.exists()) {
            return Files.size(this.getPath());
        }
        return -1L;
    }

    public final FileTime lastModified() throws IOException {
        if (this.exists()) {
            BasicFileAttributes attrs = Files.readAttributes(this.getPath(), BasicFileAttributes.class, this.options);
            return attrs.lastModifiedTime();
        }
        return null;
    }

    public boolean checkReloadRequired() throws IOException {
        FileSnapshot old = this.metadata.get();
        if (old == null) {
            this.metadata.set(FileSnapshot.save(this.file, this.options));
            return true;
        }
        FileSnapshot current = old.reload(this.file, this.options);
        this.metadata.set(current);
        return old != current;
    }

    public void resetReloadAttributes() {
        this.metadata.set(FileSnapshot.NO_FILE);
    }

    public void updateReloadAttributes() throws IOException {
        if (this.exists()) {
            this.metadata.compareAndSet(null, FileSnapshot.save(this.file, this.options));
        } else {
            this.resetReloadAttributes();
        }
    }

    public PathResource toPathResource() {
        return this.toPathResource(IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public PathResource toPathResource(OpenOption ... options) {
        return new PathResource(this.getPath(), options);
    }

    public String toString() {
        return Objects.toString(this.getPath());
    }

    public static AbstractMap.SimpleImmutableEntry<String, Object> validateStrictConfigFilePermissions(Path path, LinkOption ... options) throws IOException {
        PosixFilePermission p;
        if (path == null || !Files.exists(path, options)) {
            return null;
        }
        Set<PosixFilePermission> perms = IoUtils.getPermissions(path, options);
        if (GenericUtils.isEmpty(perms)) {
            return null;
        }
        if (OsUtils.isUNIX() && (p = IoUtils.validateExcludedPermissions(perms, STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", new Object[]{p}), p);
        }
        String owner = IoUtils.getFileOwner(path, options);
        if (GenericUtils.isEmpty(owner)) {
            return null;
        }
        String current = OsUtils.getCurrentUser();
        HashSet<String> expected = new HashSet<String>();
        expected.add(current);
        if (OsUtils.isUNIX()) {
            expected.add("root");
        }
        if (!expected.contains(owner)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(String.format("Owner violation (%s)", owner), owner);
        }
        return null;
    }
}

