/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.security.bouncycastle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.opendaylight.netconf.shaded.sshd.common.NamedResource;
import org.opendaylight.netconf.shaded.sshd.common.util.io.IoUtils;
import org.opendaylight.netconf.shaded.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;

public class BouncyCastleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public BouncyCastleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    @Override
    protected void doWriteKeyPair(NamedResource resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, outputStream);
    }

    public static void writePEMKeyPair(KeyPair kp, Path targetPath) throws IOException {
        BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, targetPath, IoUtils.EMPTY_OPEN_OPTIONS);
    }

    public static void writePEMKeyPair(KeyPair kp, Path targetPath, OpenOption ... options) throws IOException {
        try (OutputStream os = Files.newOutputStream(targetPath, options);){
            BouncyCastleGeneratorHostKeyProvider.writePEMKeyPair(kp, os);
        }
    }

    public static void writePEMKeyPair(KeyPair kp, OutputStream outputStream) throws IOException {
        try (JcaPEMWriter w = new JcaPEMWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            w.writeObject((Object)kp);
            w.flush();
        }
    }
}

