/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.security.bouncycastle;

import java.security.SecureRandom;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.opendaylight.netconf.shaded.sshd.common.random.AbstractRandom;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public final class BouncyCastleRandom
extends AbstractRandom {
    public static final String NAME = "BC";
    private final RandomGenerator random;

    public BouncyCastleRandom() {
        ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        this.random = new VMPCRandomGenerator();
        byte[] seed = new SecureRandom().generateSeed(8);
        this.random.addSeedMaterial(seed);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void fill(byte[] bytes, int start, int len) {
        this.random.nextBytes(bytes, start, len);
    }

    @Override
    public int random(int n) {
        int val;
        int bits;
        ValidateUtils.checkTrue(n > 0, "Limit must be positive: %d", n);
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    private int next(int numBits) {
        int bytes = (numBits + 7) / 8;
        byte[] next = new byte[bytes];
        int ret = 0;
        this.random.nextBytes(next);
        for (int i = 0; i < bytes; ++i) {
            ret = next[i] & 0xFF | ret << 8;
        }
        return ret >>> bytes * 8 - numBits;
    }
}

