/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import org.opendaylight.netconf.shaded.eddsa.EdDSAPrivateKey;
import org.opendaylight.netconf.shaded.eddsa.spec.EdDSANamedCurveSpec;
import org.opendaylight.netconf.shaded.eddsa.spec.EdDSANamedCurveTable;
import org.opendaylight.netconf.shaded.eddsa.spec.EdDSAPrivateKeySpec;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.GenericEd25519PEMResourceKeyParser;

public class Ed25519PEMResourceKeyParser
extends GenericEd25519PEMResourceKeyParser {
    public static final Ed25519PEMResourceKeyParser INSTANCE = new Ed25519PEMResourceKeyParser();

    public static EdDSAPrivateKey decodeEdDSAPrivateKey(byte[] keyData) throws IOException, GeneralSecurityException {
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(EdDSASupport.decodeEdDSAPrivateKey(keyData));
    }

    public static EdDSAPrivateKey generateEdDSAPrivateKey(byte[] seed) throws GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAPrivateKeySpec keySpec = new EdDSAPrivateKeySpec(seed, params);
        KeyFactory factory = SecurityUtils.getKeyFactory("EdDSA");
        return (EdDSAPrivateKey)EdDSAPrivateKey.class.cast(factory.generatePrivate(keySpec));
    }
}

