/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.bouncycastle;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.GenericEd25519PublicKeyDecoder;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.GenericOpenSSHEd25519PrivateKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic.GenericSignatureEd25519;

public class BouncyCastleEdDSASupport
implements EdDSASupport<EdDSAPublicKey, EdDSAPrivateKey> {
    @Override
    public PublicKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> getEDDSAPublicKeyEntryDecoder() {
        return new GenericEd25519PublicKeyDecoder<EdDSAPublicKey, EdDSAPrivateKey>(EdDSAPublicKey.class, EdDSAPrivateKey.class, this);
    }

    @Override
    public PrivateKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> getOpenSSHEDDSAPrivateKeyEntryDecoder() {
        return new GenericOpenSSHEd25519PrivateKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey>(EdDSAPublicKey.class, EdDSAPrivateKey.class, this);
    }

    @Override
    public Signature getEDDSASigner() {
        return new GenericSignatureEd25519("EdDSA");
    }

    @Override
    public int getEDDSAKeySize(Key key) {
        return key instanceof EdDSAKey ? 256 : -1;
    }

    @Override
    public Class<? extends PublicKey> getEDDSAPublicKeyType() {
        return EdDSAPublicKey.class;
    }

    @Override
    public Class<? extends PrivateKey> getEDDSAPrivateKeyType() {
        return EdDSAPrivateKey.class;
    }

    @Override
    public boolean compareEDDSAPPublicKeys(PublicKey k1, PublicKey k2) {
        if (!(k1 instanceof EdDSAPublicKey) || !(k2 instanceof EdDSAPublicKey)) {
            return false;
        }
        return k1.equals(k2);
    }

    @Override
    public boolean compareEDDSAPrivateKeys(PrivateKey k1, PrivateKey k2) {
        if (!(k1 instanceof EdDSAPrivateKey) || !(k2 instanceof EdDSAPrivateKey)) {
            return false;
        }
        return k1.equals(k2);
    }

    @Override
    public EdDSAPublicKey recoverEDDSAPublicKey(PrivateKey key) throws GeneralSecurityException {
        if (!(key instanceof EdDSAPrivateKey)) {
            throw new InvalidKeyException("Private key is not EdDSA");
        }
        EdDSAPrivateKey edDSAKey = (EdDSAPrivateKey)key;
        return edDSAKey.getPublicKey();
    }

    @Override
    public EdDSAPublicKey generateEDDSAPublicKey(byte[] seed) throws GeneralSecurityException {
        RawEncodedKeySpec keySpec = new RawEncodedKeySpec(seed);
        KeyFactory factory = SecurityUtils.getKeyFactory(this.getKeyFactoryAlgorithm());
        return (EdDSAPublicKey)factory.generatePublic((KeySpec)keySpec);
    }

    @Override
    public EdDSAPrivateKey generateEDDSAPrivateKey(byte[] seed) throws GeneralSecurityException, IOException {
        Ed25519PrivateKeyParameters parameters = new Ed25519PrivateKeyParameters(seed);
        PrivateKeyInfo info = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)parameters);
        KeyFactory factory = SecurityUtils.getKeyFactory(this.getKeyFactoryAlgorithm());
        return (EdDSAPrivateKey)factory.generatePrivate(new PKCS8EncodedKeySpec(info.getEncoded()));
    }

    @Override
    public <B extends Buffer> B putRawEDDSAPublicKey(B buffer, PublicKey key) {
        EdDSAPublicKey edKey = ValidateUtils.checkInstanceOf((Object)key, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)key);
        buffer.putBytes(edKey.getPointEncoding());
        return buffer;
    }

    @Override
    public <B extends Buffer> B putEDDSAKeyPair(B buffer, PublicKey pubKey, PrivateKey prvKey) {
        ValidateUtils.checkInstanceOf((Object)pubKey, EdDSAPublicKey.class, "Not an EDDSA public key: %s", (Object)pubKey);
        ValidateUtils.checkInstanceOf((Object)prvKey, EdDSAPrivateKey.class, "Not an EDDSA private key: %s", (Object)prvKey);
        throw new UnsupportedOperationException("Full SSHD-440 implementation N/A");
    }

    @Override
    public KeySpec createPublicKeySpec(EdDSAPublicKey publicKey) {
        return new RawEncodedKeySpec(publicKey.getPointEncoding());
    }

    @Override
    public KeySpec createPrivateKeySpec(EdDSAPrivateKey privateKey) {
        return new PKCS8EncodedKeySpec(privateKey.getEncoded());
    }

    @Override
    public byte[] getPublicKeyData(EdDSAPublicKey publicKey) {
        return publicKey == null ? null : publicKey.getPointEncoding();
    }

    @Override
    public byte[] getPrivateKeyData(EdDSAPrivateKey privateKey) throws IOException {
        Ed25519PrivateKeyParameters parameters = (Ed25519PrivateKeyParameters)PrivateKeyFactory.createKey((byte[])privateKey.getEncoded());
        return parameters.getEncoded();
    }

    @Override
    public String getKeyFactoryAlgorithm() {
        return "Ed25519";
    }
}

