/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.common.util.security.eddsa.generic;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Object;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.ASN1Type;
import org.opendaylight.netconf.shaded.sshd.common.util.io.der.DERParser;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;

public interface EdDSASupport<PUB extends PublicKey, PRV extends PrivateKey> {
    public static final int KEY_SIZE = 256;
    public static final String ED25519_OID = "1.3.101.112";

    public static KeyPair decodeEd25519KeyPair(byte[] keyData) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = EdDSASupport.decodeEdDSAPrivateKey(keyData);
        PublicKey publicKey = SecurityUtils.recoverEDDSAPublicKey(privateKey);
        return new KeyPair(publicKey, privateKey);
    }

    public static PrivateKey decodeEdDSAPrivateKey(byte[] keyData) throws IOException, GeneralSecurityException {
        try (DERParser parser = new DERParser(keyData);){
            ASN1Object obj = parser.readObject();
            if (obj == null) {
                throw new StreamCorruptedException("Missing key data container");
            }
            ASN1Type objType = obj.getObjType();
            if (objType != ASN1Type.OCTET_STRING) {
                throw new StreamCorruptedException("Mismatched key data container type: " + (Object)((Object)objType));
            }
            PrivateKey privateKey = SecurityUtils.generateEDDSAPrivateKey("ssh-ed25519", obj.getValue());
            return privateKey;
        }
    }

    public PublicKeyEntryDecoder<PUB, PRV> getEDDSAPublicKeyEntryDecoder();

    public PrivateKeyEntryDecoder<PUB, PRV> getOpenSSHEDDSAPrivateKeyEntryDecoder();

    public Signature getEDDSASigner();

    public int getEDDSAKeySize(Key var1);

    public Class<? extends PublicKey> getEDDSAPublicKeyType();

    public Class<? extends PrivateKey> getEDDSAPrivateKeyType();

    public boolean compareEDDSAPPublicKeys(PublicKey var1, PublicKey var2);

    public boolean compareEDDSAPrivateKeys(PrivateKey var1, PrivateKey var2);

    public PUB recoverEDDSAPublicKey(PrivateKey var1) throws GeneralSecurityException;

    public PUB generateEDDSAPublicKey(byte[] var1) throws GeneralSecurityException;

    public PRV generateEDDSAPrivateKey(byte[] var1) throws GeneralSecurityException, IOException;

    public <B extends Buffer> B putRawEDDSAPublicKey(B var1, PublicKey var2);

    public <B extends Buffer> B putEDDSAKeyPair(B var1, PublicKey var2, PrivateKey var3);

    public KeySpec createPublicKeySpec(PUB var1);

    public KeySpec createPrivateKeySpec(PRV var1);

    public byte[] getPublicKeyData(PUB var1);

    public byte[] getPrivateKeyData(PRV var1) throws IOException;

    public String getKeyFactoryAlgorithm();
}

