/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.opendaylight.netconf.shaded.sshd.common.AttributeRepository;
import org.opendaylight.netconf.shaded.sshd.common.future.CancelFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.DefaultIoConnectFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.IoConnectFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.IoConnector;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceEventListener;
import org.opendaylight.netconf.shaded.sshd.core.CoreModuleProperties;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoService;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactory;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoSession;

public class NettyIoConnector
extends NettyIoService
implements IoConnector {
    private static final LoggingHandler LOGGING_TRACE = new LoggingHandler(NettyIoConnector.class, LogLevel.TRACE);

    public NettyIoConnector(NettyIoServiceFactory factory, IoHandler handler) {
        super(factory, handler);
        this.channelGroup = new DefaultChannelGroup("sshd-connector-channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    @Override
    public IoConnectFuture connect(SocketAddress address, final AttributeRepository context, SocketAddress localAddress) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture(address, null);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.factory.eventLoopGroup)).channel(NioSocketChannel.class)).attr(CONNECT_FUTURE_KEY, (Object)future)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                IoServiceEventListener listener = NettyIoConnector.this.getIoServiceEventListener();
                InetSocketAddress local = ch.localAddress();
                InetSocketAddress remote = ch.remoteAddress();
                try {
                    if (listener != null) {
                        try {
                            listener.connectionEstablished(NettyIoConnector.this, local, context, remote);
                        }
                        catch (Exception e) {
                            ch.close();
                            throw e;
                        }
                    }
                    NettyIoSession session = new NettyIoSession(NettyIoConnector.this, NettyIoConnector.this.handler, null);
                    if (context != null) {
                        session.setAttribute(AttributeRepository.class, context);
                    }
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{LOGGING_TRACE});
                    p.addLast(new ChannelHandler[]{session.adapter});
                }
                catch (Exception e) {
                    block9: {
                        if (listener != null) {
                            try {
                                listener.abortEstablishedConnection(NettyIoConnector.this, local, context, remote, e);
                            }
                            catch (Exception exc) {
                                if (!NettyIoConnector.this.log.isDebugEnabled()) break block9;
                                NettyIoConnector.this.log.debug("initChannel(" + ch + ") listener=" + listener + " ignoring abort event exception", (Throwable)exc);
                            }
                        }
                    }
                    throw e;
                }
            }
        });
        CoreModuleProperties.IO_CONNECT_TIMEOUT.get(this.factory.manager).ifPresent(d -> {
            long millis;
            if (d.isZero() || d.isNegative()) {
                return;
            }
            try {
                millis = d.toMillis();
            }
            catch (ArithmeticException e) {
                millis = Integer.MAX_VALUE;
            }
            if (millis > Integer.MAX_VALUE) {
                millis = Integer.MAX_VALUE;
            }
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)millis));
        });
        ChannelFuture chf = localAddress != null ? bootstrap.connect(address, localAddress) : bootstrap.connect(address);
        future.addListener(f -> {
            if (f.isCanceled() && (chf.cancel(true) || chf.isCancelled())) {
                f.getCancellation().setCanceled();
            }
        });
        chf.addListener(cf -> {
            CancelFuture cancellation;
            Throwable t = cf.cause();
            if (t != null) {
                future.setException(t);
            } else if (cf.isCancelled() && (cancellation = future.cancel()) != null) {
                cancellation.setCanceled();
            }
        });
        return future;
    }
}

