/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.future.CloseFuture;
import org.opendaylight.netconf.shaded.sshd.common.io.IoAcceptor;
import org.opendaylight.netconf.shaded.sshd.common.io.IoConnector;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceEventListener;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceFactory;
import org.opendaylight.netconf.shaded.sshd.common.util.closeable.AbstractCloseable;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoAcceptor;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoConnector;

public class NettyIoServiceFactory
extends AbstractCloseable
implements IoServiceFactory {
    protected final EventLoopGroup eventLoopGroup;
    protected final boolean closeEventLoopGroup;
    protected final FactoryManager manager;
    private IoServiceEventListener eventListener;

    public NettyIoServiceFactory(FactoryManager manager) {
        this(manager, null);
    }

    public NettyIoServiceFactory(FactoryManager manager, EventLoopGroup group) {
        this.manager = Objects.requireNonNull(manager, "FactoryManager must be set");
        this.eventLoopGroup = group != null ? group : new NioEventLoopGroup();
        this.closeEventLoopGroup = group == null;
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return new NettyIoConnector(this, handler);
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return new NettyIoAcceptor(this, handler);
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        if (this.closeEventLoopGroup) {
            Future shutdownFuture = this.eventLoopGroup.shutdownGracefully();
            shutdownFuture.addListener(fut -> this.closeFuture.setClosed());
        } else {
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    @Override
    protected void doCloseImmediately() {
        this.doCloseGracefully();
        super.doCloseImmediately();
    }
}

