/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.auth.gss;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.opendaylight.netconf.shaded.sshd.server.auth.gss.CredentialHelper;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class GSSAuthenticator {
    private String servicePrincipalName;
    private String keytabFile;

    public GSSManager getGSSManager() {
        return GSSManager.getInstance();
    }

    public GSSCredential getGSSCredential(GSSManager mgr) throws UnknownHostException, LoginException, GSSException {
        String name = this.servicePrincipalName;
        if (name == null) {
            name = "host/" + InetAddress.getLocalHost().getCanonicalHostName();
        }
        return CredentialHelper.creds(mgr, name, this.keytabFile);
    }

    public boolean validateInitialUser(ServerSession session, String user) {
        return true;
    }

    public boolean validateIdentity(ServerSession session, String identity) {
        return true;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public void setKeytabFile(String keytabFile) {
        this.keytabFile = keytabFile;
    }
}

