/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.auth.password;

import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.PasswordAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.session.ServerSession;

public class StaticPasswordAuthenticator
extends AbstractLoggingBean
implements PasswordAuthenticator {
    private final boolean acceptance;

    public StaticPasswordAuthenticator(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String username, String password, ServerSession session) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(username, password, session);
        } else {
            this.handleRejection(username, password, session);
        }
        return accepted;
    }

    protected void handleAcceptance(String username, String password, ServerSession session) {
        this.log.warn("authenticate({}[{}]: accepted without checking", (Object)username, (Object)session);
    }

    protected void handleRejection(String username, String password, ServerSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}]: rejected", (Object)username, (Object)session);
        }
    }
}

