/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opendaylight.netconf.shaded.sshd.common.PropertyResolver;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelPipedInputStream;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelPipedOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.channel.LocalWindow;
import org.opendaylight.netconf.shaded.sshd.common.util.io.output.LoggingFilterOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelDataReceiver;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSession;

public class PipeDataReceiver
extends AbstractLoggingBean
implements ChannelDataReceiver {
    private InputStream in;
    private OutputStream out;

    public PipeDataReceiver(PropertyResolver resolver, LocalWindow localWindow) {
        ChannelPipedInputStream in = new ChannelPipedInputStream(resolver, localWindow);
        this.in = in;
        this.out = new ChannelPipedOutputStream(in);
        if (this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "IN(" + resolver + "): ", this.log, resolver);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        this.out.write(buf, start, len);
        return 0;
    }
}

