/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.command;

import java.io.IOException;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.logging.AbstractLoggingBean;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSession;
import org.opendaylight.netconf.shaded.sshd.server.command.Command;
import org.opendaylight.netconf.shaded.sshd.server.command.CommandFactory;

public abstract class AbstractDelegatingCommandFactory
extends AbstractLoggingBean
implements CommandFactory {
    private final String name;
    private CommandFactory delegate;

    protected AbstractDelegatingCommandFactory(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No delegating command factory name provided");
    }

    public String toString() {
        return this.name;
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public void setDelegateCommandFactory(CommandFactory factory) {
        this.delegate = factory;
    }

    @Override
    public Command createCommand(ChannelSession channel, String command) throws IOException {
        if (this.isSupportedCommand(channel, command)) {
            return this.executeSupportedCommand(channel, command);
        }
        CommandFactory factory = this.getDelegateCommandFactory();
        if (factory != null) {
            return factory.createCommand(channel, command);
        }
        return this.createUnsupportedCommand(channel, command);
    }

    public abstract boolean isSupportedCommand(ChannelSession var1, String var2);

    protected abstract Command executeSupportedCommand(ChannelSession var1, String var2);

    protected Command createUnsupportedCommand(ChannelSession channel, String command) {
        throw new IllegalArgumentException("Unknown command to execute: " + command);
    }
}

