/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.shell;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.netconf.shaded.sshd.common.channel.PtyMode;
import org.opendaylight.netconf.shaded.sshd.common.util.GenericUtils;
import org.opendaylight.netconf.shaded.sshd.server.shell.TtyFilterInputStream;

public class TtyFilterOutputStream
extends FilterOutputStream {
    public static final Set<PtyMode> OUTPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.ECHO, PtyMode.INLCR, PtyMode.ICRNL, PtyMode.IGNCR));
    private final Set<PtyMode> ttyOptions;
    private final TtyFilterInputStream echo;

    public TtyFilterOutputStream(OutputStream out, TtyFilterInputStream echo, Map<PtyMode, ?> modes) {
        this(out, echo, PtyMode.resolveEnabledOptions(modes, OUTPUT_OPTIONS));
    }

    public TtyFilterOutputStream(OutputStream out, TtyFilterInputStream echo, Collection<PtyMode> ttyOptions) {
        super(out);
        this.ttyOptions = GenericUtils.of(ttyOptions);
        this.echo = this.ttyOptions.contains((Object)PtyMode.ECHO) ? Objects.requireNonNull(echo, "No echo stream") : echo;
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 13) {
            this.handleCR();
        } else if (c == 10) {
            this.handleLF();
        } else {
            this.writeRawOutput(c);
        }
    }

    protected void handleCR() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.ICRNL)) {
            this.writeRawOutput(10);
        } else {
            if (this.ttyOptions.contains((Object)PtyMode.IGNCR)) {
                return;
            }
            this.writeRawOutput(13);
        }
    }

    protected void handleLF() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.INLCR)) {
            this.writeRawOutput(13);
        } else {
            this.writeRawOutput(10);
        }
    }

    protected void writeRawOutput(int c) throws IOException {
        this.out.write(c);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(c);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            this.write(b[off] & 0xFF);
            return;
        }
        int lastPos = 0;
        int maxPos = off + len;
        for (int curPos = off; curPos < maxPos; ++curPos) {
            int c = b[curPos] & 0xFF;
            if (c != 13 && c != 10) continue;
            if (lastPos < curPos) {
                this.writeRawOutput(b, lastPos, curPos - lastPos);
            }
            lastPos = curPos + 1;
            this.write(c);
        }
        if (lastPos < maxPos) {
            this.writeRawOutput(b, lastPos, maxPos - lastPos);
        }
    }

    protected void writeRawOutput(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.ttyOptions.contains((Object)PtyMode.ECHO)) {
            this.echo.write(b, off, len);
        }
    }
}

