/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.server.Environment;
import org.opendaylight.netconf.shaded.sshd.server.ExitCallback;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSession;
import org.opendaylight.netconf.shaded.sshd.server.command.Command;

public class UnknownCommand
implements Command,
Runnable {
    private final String command;
    private final String message;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;

    public UnknownCommand(String command) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "No command");
        this.message = "Unknown command: " + command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        String errorMessage = this.getMessage();
        try {
            try {
                this.err.write(errorMessage.getBytes(StandardCharsets.UTF_8));
                this.err.write(10);
            }
            finally {
                this.err.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.callback != null) {
            this.callback.onExit(1, errorMessage);
        }
    }

    @Override
    public void start(ChannelSession channel, Environment env) throws IOException {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void destroy(ChannelSession channel) {
    }

    public int hashCode() {
        return Objects.hashCode(this.getCommand());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.getCommand(), ((UnknownCommand)obj).getCommand());
    }

    public String toString() {
        return this.getMessage();
    }
}

