/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.shaded.sshd.server.x11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opendaylight.netconf.shaded.sshd.client.channel.AbstractClientChannel;
import org.opendaylight.netconf.shaded.sshd.client.future.DefaultOpenFuture;
import org.opendaylight.netconf.shaded.sshd.client.future.OpenFuture;
import org.opendaylight.netconf.shaded.sshd.common.Closeable;
import org.opendaylight.netconf.shaded.sshd.common.SshException;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.channel.LocalWindow;
import org.opendaylight.netconf.shaded.sshd.common.channel.StreamingChannel;
import org.opendaylight.netconf.shaded.sshd.common.io.IoSession;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.util.ValidateUtils;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.Buffer;
import org.opendaylight.netconf.shaded.sshd.common.util.buffer.ByteArrayBuffer;

public class ChannelForwardedX11
extends AbstractClientChannel {
    private final IoSession serverSession;

    public ChannelForwardedX11(IoSession serverSession) {
        super("x11");
        this.serverSession = serverSession;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        InetSocketAddress remote = (InetSocketAddress)this.serverSession.getRemoteAddress();
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(remote, this.futureLock);
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        InetAddress remoteAddress = remote.getAddress();
        String remoteHost = remoteAddress.getHostAddress();
        LocalWindow wLocal = this.getLocalWindow();
        String type = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, remoteHost.length() + type.length() + 32);
        buffer.putString(type);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(wLocal.getSize());
        buffer.putUInt(wLocal.getPacketSize());
        buffer.putString(remoteHost);
        buffer.putUInt(remote.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (StreamingChannel.Streaming.Async.equals((Object)this.streaming)) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        LocalWindow wLocal = this.getLocalWindow();
        wLocal.release(len);
        ByteArrayBuffer packet = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        this.serverSession.writeBuffer(packet);
    }

    @Override
    public void handleEof() throws IOException {
        super.handleEof();
        this.serverSession.close(false);
    }
}

