/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.api;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.AbstractTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.TransportStack;
import org.opendaylight.yangtools.yang.common.Empty;

public abstract class AbstractOverlayTransportStack<C extends TransportChannel>
extends AbstractTransportStack<C> {
    private final @NonNull TransportChannelListener<TransportChannel> asListener = new TransportChannelListener<TransportChannel>(){

        @Override
        public void onTransportChannelFailed(Throwable cause) {
            AbstractOverlayTransportStack.this.notifyTransportChannelFailed(cause);
        }

        @Override
        public void onTransportChannelEstablished(TransportChannel channel) {
            AbstractOverlayTransportStack.this.onUnderlayChannelEstablished(channel);
        }
    };
    private volatile TransportStack underlay = null;

    protected AbstractOverlayTransportStack(TransportChannelListener listener) {
        super(listener);
    }

    @Override
    protected final ListenableFuture<Empty> startShutdown() {
        return this.underlay.shutdown();
    }

    protected final @NonNull TransportChannelListener asListener() {
        return this.asListener;
    }

    protected abstract void onUnderlayChannelEstablished(@NonNull TransportChannel var1);

    final void setUnderlay(TransportStack underlay) {
        this.underlay = Objects.requireNonNull(underlay);
    }

    protected static final <T extends AbstractOverlayTransportStack<?>> @NonNull ListenableFuture<T> transformUnderlay(T stack, ListenableFuture<? extends TransportStack> tcpFuture) {
        return Futures.transform(tcpFuture, tcpStack -> {
            stack.setUnderlay((TransportStack)tcpStack);
            return stack;
        }, (Executor)MoreExecutors.directExecutor());
    }
}

