/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.api;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.TransportStack;
import org.opendaylight.yangtools.yang.common.Empty;

public abstract class AbstractTransportStack<C extends TransportChannel>
implements TransportStack {
    private final @NonNull TransportChannelListener<? super C> listener;
    private Object state;

    protected AbstractTransportStack(TransportChannelListener listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListenableFuture<Empty> shutdown() {
        SettableFuture future;
        Set<TransportChannel> channels;
        AbstractTransportStack abstractTransportStack = this;
        synchronized (abstractTransportStack) {
            Object local = this.state;
            if (local instanceof ListenableFuture) {
                return (ListenableFuture)local;
            }
            if (local == null) {
                channels = Set.of();
            } else if (local instanceof Set) {
                channels = (Set<TransportChannel>)local;
            } else if (local instanceof TransportChannel) {
                TransportChannel tc = (TransportChannel)local;
                channels = Set.of(tc);
            } else {
                throw new IllegalStateException("Unexpected state " + String.valueOf(local));
            }
            future = SettableFuture.create();
            this.state = future;
        }
        ArrayList<ListenableFuture<Empty>> futures = new ArrayList<ListenableFuture<Empty>>(channels.size() + 1);
        futures.add(this.startShutdown());
        for (TransportChannel channel : channels) {
            futures.add(AbstractTransportStack.toListenableFuture(channel.channel().close()));
        }
        Futures.whenAllComplete(futures).run(() -> future.set((Object)Empty.value()), MoreExecutors.directExecutor());
        return future;
    }

    protected abstract @NonNull ListenableFuture<Empty> startShutdown();

    protected final void addTransportChannel(@NonNull C channel) {
        Channel ch = ((TransportChannel)channel).channel();
        if (this.add((TransportChannel)channel)) {
            ch.closeFuture().addListener(ignored -> this.remove((TransportChannel)channel));
            this.listener.onTransportChannelEstablished(channel);
        } else {
            ch.close();
        }
    }

    protected final void notifyTransportChannelFailed(@NonNull Throwable cause) {
        this.listener.onTransportChannelFailed(cause);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected synchronized MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("listener", this.listener).add("state", this.state);
    }

    protected static final @NonNull ListenableFuture<Empty> toListenableFuture(Future<?> nettyFuture) {
        SettableFuture ret = SettableFuture.create();
        nettyFuture.addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                ret.setException(cause);
            } else {
                ret.set((Object)Empty.value());
            }
        });
        return ret;
    }

    private synchronized boolean add(@NonNull TransportChannel channel) {
        Object local = this.state;
        if (local instanceof ListenableFuture) {
            return false;
        }
        if (local == null) {
            this.state = channel;
        } else if (local instanceof Set) {
            ((Set)local).add(channel);
        } else if (local instanceof TransportChannel) {
            TransportChannel tc = (TransportChannel)local;
            HashSet<TransportChannel> set = new HashSet<TransportChannel>(4);
            set.add(tc);
            set.add(channel);
            this.state = set;
        } else {
            throw new IllegalStateException("Unhandled state " + String.valueOf(local));
        }
        return true;
    }

    private synchronized void remove(@NonNull TransportChannel channel) {
        Object local = this.state;
        if (local == null || local instanceof ListenableFuture) {
            return;
        }
        if (local.equals(channel)) {
            this.state = null;
        } else if (local instanceof Set) {
            Set set = (Set)local;
            set.remove(channel);
        } else {
            throw new IllegalStateException("Unhandled state " + String.valueOf(local));
        }
    }
}

