/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;

@NonNullByDefault
final class EpollNettyImpl
extends NettyImpl {
    private static final NettyTcpKeepaliveOptions KEEPALIVE_OPTIONS = new NettyTcpKeepaliveOptions((ChannelOption<Integer>)EpollChannelOption.TCP_KEEPCNT, (ChannelOption<Integer>)EpollChannelOption.TCP_KEEPIDLE, (ChannelOption<Integer>)EpollChannelOption.TCP_KEEPINTVL);

    EpollNettyImpl() {
    }

    Class<EpollDatagramChannel> datagramChannelClass() {
        return EpollDatagramChannel.class;
    }

    Class<EpollSocketChannel> channelClass() {
        return EpollSocketChannel.class;
    }

    Class<EpollServerSocketChannel> serverChannelClass() {
        return EpollServerSocketChannel.class;
    }

    @Override
    EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        return new EpollEventLoopGroup(numThreads, threadFactory);
    }

    @Override
    @NonNull NettyTcpKeepaliveOptions keepaliveOptions() {
        return KEEPALIVE_OPTIONS;
    }

    @Override
    public String toString() {
        return "epoll(2)";
    }
}

