/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import com.google.common.annotations.Beta;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.spi.EpollNettyImpl;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.NioNettyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
public final class NettyTransportSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTransportSupport.class);
    private static final NettyImpl IMPL = Epoll.isAvailable() ? new EpollNettyImpl() : NioNettyImpl.INSTANCE;

    private NettyTransportSupport() {
    }

    public static Bootstrap newBootstrap() {
        return (Bootstrap)new Bootstrap().channel(IMPL.channelClass());
    }

    public static Bootstrap newDatagramBootstrap() {
        return (Bootstrap)new Bootstrap().channel(IMPL.datagramChannelClass());
    }

    public static ServerBootstrap newServerBootstrap() {
        return (ServerBootstrap)new ServerBootstrap().channel(IMPL.serverChannelClass());
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        return IMPL.newEventLoopGroup(numThreads, Objects.requireNonNull(threadFactory));
    }

    public static @Nullable NettyTcpKeepaliveOptions tcpKeepaliveOptions() {
        return IMPL.keepaliveOptions();
    }

    public static NettyTcpKeepaliveOptions getTcpKeepaliveOptions() throws UnsupportedConfigurationException {
        NettyTcpKeepaliveOptions options = NettyTransportSupport.tcpKeepaliveOptions();
        if (options == null) {
            throw new UnsupportedConfigurationException("TCP keepalives are not supported");
        }
        return options;
    }

    static {
        LOG.info("Netty transport backed by {}", (Object)IMPL);
    }
}

