/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import jdk.net.ExtendedSocketOptions;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;

@NonNullByDefault
final class NioNettyImpl
extends NettyImpl {
    private static final NettyTcpKeepaliveOptions KEEPALIVE_OPTIONS = new NettyTcpKeepaliveOptions((ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPCOUNT), (ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPIDLE), (ChannelOption<Integer>)NioChannelOption.of(ExtendedSocketOptions.TCP_KEEPINTERVAL));
    static final NioNettyImpl INSTANCE;
    private final boolean supportsKeepalives;

    private NioNettyImpl(boolean supportsKeepalives) {
        this.supportsKeepalives = supportsKeepalives;
    }

    Class<NioDatagramChannel> datagramChannelClass() {
        return NioDatagramChannel.class;
    }

    Class<NioSocketChannel> channelClass() {
        return NioSocketChannel.class;
    }

    Class<NioServerSocketChannel> serverChannelClass() {
        return NioServerSocketChannel.class;
    }

    @Override
    EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        return new NioEventLoopGroup(numThreads, threadFactory);
    }

    @Override
    @Nullable NettyTcpKeepaliveOptions keepaliveOptions() {
        return this.supportsKeepalives ? KEEPALIVE_OPTIONS : null;
    }

    @Override
    public String toString() {
        return "java.nio";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        NioEventLoopGroup grp = new NioEventLoopGroup();
        try {
            try {
                boolean supportsKeepalives;
                NioSocketChannel ch = new NioSocketChannel();
                grp.register((Channel)ch).sync();
                try {
                    supportsKeepalives = ch.config().setOptions(Map.of(ChannelOption.SO_KEEPALIVE, Boolean.TRUE, KEEPALIVE_OPTIONS.tcpKeepIdle(), 7200, KEEPALIVE_OPTIONS.tcpKeepCnt(), 3, KEEPALIVE_OPTIONS.tcpKeepIntvl(), 5));
                }
                finally {
                    ch.close().sync();
                }
                INSTANCE = new NioNettyImpl(supportsKeepalives);
            }
            finally {
                grp.shutdownGracefully().sync();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExceptionInInitializerError(e);
        }
    }
}

