/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.TcpMd5Secrets;

@NonNullByDefault
final class EpollNettyImpl
extends NettyImpl {
    private static final NettyTcpKeepaliveOptions KEEPALIVE_OPTIONS = new NettyTcpKeepaliveOptions((ChannelOption<Integer>)EpollChannelOption.TCP_KEEPCNT, (ChannelOption<Integer>)EpollChannelOption.TCP_KEEPIDLE, (ChannelOption<Integer>)EpollChannelOption.TCP_KEEPINTVL);
    private final IoHandlerFactory ioHandlerFactory = EpollIoHandler.newFactory();

    EpollNettyImpl() {
    }

    Class<EpollDatagramChannel> datagramChannelClass() {
        return EpollDatagramChannel.class;
    }

    Class<EpollSocketChannel> channelClass() {
        return EpollSocketChannel.class;
    }

    Class<EpollServerSocketChannel> serverChannelClass() {
        return EpollServerSocketChannel.class;
    }

    @Override
    IoHandlerFactory ioHandlerFactory() {
        return this.ioHandlerFactory;
    }

    @Override
    @NonNull NettyTcpKeepaliveOptions keepaliveOptions() {
        return KEEPALIVE_OPTIONS;
    }

    @Override
    void setTcpMd5(AbstractBootstrap<?, ?> bootstrap, TcpMd5Secrets secrets) {
        bootstrap.option(EpollChannelOption.TCP_MD5SIG, secrets.toOption());
    }

    @Override
    boolean setTcpMd5(Channel channel, TcpMd5Secrets secrets) {
        return channel.config().setOption(EpollChannelOption.TCP_MD5SIG, secrets.toOption());
    }

    @Override
    public String toString() {
        return "epoll(2)";
    }
}

