/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.spi;

import com.google.common.annotations.Beta;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.epoll.Epoll;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.spi.EpollNettyImpl;
import org.opendaylight.netconf.transport.spi.NettyImpl;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.NioNettyImpl;
import org.opendaylight.netconf.transport.spi.TcpMd5Secrets;
import org.slf4j.LoggerFactory;

@Beta
@NonNullByDefault
public final class NettyTransportSupport {
    private static final NettyImpl IMPL;

    private NettyTransportSupport() {
    }

    public static Bootstrap newBootstrap() {
        return (Bootstrap)new Bootstrap().channel(IMPL.channelClass());
    }

    public static Bootstrap newDatagramBootstrap() {
        return (Bootstrap)new Bootstrap().channel(IMPL.datagramChannelClass());
    }

    public static ServerBootstrap newServerBootstrap() {
        return (ServerBootstrap)new ServerBootstrap().channel(IMPL.serverChannelClass());
    }

    public static EventLoopGroup newEventLoopGroup(int numThreads, ThreadFactory threadFactory) {
        return new MultiThreadIoEventLoopGroup(numThreads, Objects.requireNonNull(threadFactory), IMPL.ioHandlerFactory());
    }

    public static @Nullable NettyTcpKeepaliveOptions tcpKeepaliveOptions() {
        return IMPL.keepaliveOptions();
    }

    public static NettyTcpKeepaliveOptions getTcpKeepaliveOptions() throws UnsupportedConfigurationException {
        NettyTcpKeepaliveOptions options = NettyTransportSupport.tcpKeepaliveOptions();
        if (options == null) {
            throw new UnsupportedConfigurationException("TCP keepalives are not supported");
        }
        return options;
    }

    public static void setTcpMd5(AbstractBootstrap<?, ?> bootstrap, TcpMd5Secrets secrets) throws UnsupportedConfigurationException {
        IMPL.setTcpMd5(bootstrap, secrets);
    }

    public static boolean setTcpMd5(Channel channel, TcpMd5Secrets secrets) throws UnsupportedConfigurationException {
        return IMPL.setTcpMd5(channel, secrets);
    }

    static {
        Throwable epollCause = Epoll.unavailabilityCause();
        IMPL = epollCause == null ? new EpollNettyImpl() : new NioNettyImpl(epollCause);
        LoggerFactory.getLogger(NettyTransportSupport.class).info("Netty transport backed by {}", (Object)IMPL);
    }
}

