/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.shaded.sshd.client.future.AuthFuture;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactoryFactory;
import org.opendaylight.netconf.transport.api.AbstractOverlayTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.ssh.SSHTransportChannel;
import org.opendaylight.netconf.transport.ssh.SSHTransportStack;
import org.opendaylight.netconf.transport.ssh.TransportClientSession;
import org.opendaylight.netconf.transport.ssh.TransportClientSubsystem;
import org.opendaylight.netconf.transport.ssh.TransportSshClient;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.opendaylight.netconf.transport.tcp.TCPClient;
import org.opendaylight.netconf.transport.tcp.TCPServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.TransportParamsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSHClient
extends SSHTransportStack {
    private static final Logger LOG = LoggerFactory.getLogger(SSHClient.class);
    private final String subsystem;

    private SSHClient(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TransportSshClient sshClient) {
        super(listener, (FactoryManager)sshClient, (IoHandler)sshClient.getSessionFactory());
        if (subsystem.isBlank()) {
            throw new IllegalArgumentException("Blank subsystem");
        }
        this.subsystem = subsystem;
    }

    static SSHClient of(NettyIoServiceFactoryFactory ioServiceFactory, ScheduledExecutorService executorService, String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, SshClientGrouping clientParams, ClientFactoryManagerConfigurator configurator) throws UnsupportedConfigurationException {
        return new SSHClient(subsystem, listener, new TransportSshClient.Builder(ioServiceFactory, executorService).transportParams((TransportParamsGrouping)clientParams.getTransportParams()).keepAlives(clientParams.getKeepalives()).clientIdentity(clientParams.getClientIdentity()).serverAuthentication(clientParams.getServerAuthentication()).configurator(configurator).buildChecked());
    }

    @VisibleForTesting
    static SSHClient of(String subsystem, TransportChannelListener<? super SSHTransportChannel> listener, TransportSshClient transportSshClient) throws UnsupportedConfigurationException {
        return new SSHClient(subsystem, listener, transportSshClient);
    }

    @NonNull ListenableFuture<SSHClient> connect(Bootstrap bootstrap, TcpClientGrouping connectParams) throws UnsupportedConfigurationException {
        return SSHClient.transformUnderlay((AbstractOverlayTransportStack)this, (ListenableFuture)TCPClient.connect((TransportChannelListener)this.asListener(), (Bootstrap)bootstrap, (TcpClientGrouping)connectParams));
    }

    @NonNull ListenableFuture<SSHClient> listen(ServerBootstrap bootstrap, TcpServerGrouping listenParams) throws UnsupportedConfigurationException {
        return SSHClient.transformUnderlay((AbstractOverlayTransportStack)this, (ListenableFuture)TCPServer.listen((TransportChannelListener)this.asListener(), (ServerBootstrap)bootstrap, (TcpServerGrouping)listenParams));
    }

    @Override
    void onKeyEstablished(Session session) throws IOException {
        TransportClientSession clientSession = SSHClient.cast(session);
        if (clientSession.isAuthenticated()) {
            return;
        }
        Long sessionId = SSHClient.sessionId((Session)clientSession);
        LOG.debug("Authenticating session {}", (Object)sessionId);
        clientSession.auth().addListener(future -> this.onAuthComplete((AuthFuture)future, sessionId));
    }

    private void onAuthComplete(AuthFuture future, Long sessionId) {
        Throwable cause = future.getException();
        if (cause != null) {
            LOG.info("Session {} authentication failed", (Object)sessionId, (Object)cause);
            this.transportFailed(sessionId, cause);
        } else if (future.isFailure()) {
            LOG.info("Session {} authentication rejected", (Object)sessionId);
            this.transportFailed(sessionId, new IOException("Failed to authenticate"));
        } else {
            LOG.debug("Session {} authenticated", (Object)sessionId);
        }
    }

    @Override
    void onAuthenticated(Session session) throws IOException {
        final Long sessionId = SSHClient.sessionId(session);
        LOG.debug("Opening \"{}\" subsystem on session {}", (Object)this.subsystem, (Object)sessionId);
        TransportChannel underlay = this.getUnderlayOf(sessionId);
        TransportClientSession clientSession = SSHClient.cast(session);
        TransportClientSubsystem channel = clientSession.createSubsystemChannel(this.subsystem);
        channel.onClose(() -> clientSession.close(true));
        Futures.addCallback(channel.open(underlay), (FutureCallback)new FutureCallback<ChannelHandlerContext>(){

            public void onSuccess(ChannelHandlerContext result) {
                LOG.debug("Opened \"{}\" subsystem on session {}", (Object)SSHClient.this.subsystem, (Object)sessionId);
                SSHClient.this.transportEstablished(sessionId, result);
            }

            public void onFailure(Throwable cause) {
                LOG.error("Failed to open \"{}\" subsystem on session {}", new Object[]{SSHClient.this.subsystem, sessionId, cause});
                SSHClient.this.transportFailed(sessionId, cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static TransportClientSession cast(Session session) throws IOException {
        return TransportUtils.checkCast(TransportClientSession.class, session);
    }
}

