/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.io.EOFException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.SshConstants;
import org.opendaylight.netconf.shaded.sshd.common.io.IoHandler;
import org.opendaylight.netconf.shaded.sshd.common.session.Session;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionListener;
import org.opendaylight.netconf.transport.api.AbstractOverlayTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.ssh.SSHClient;
import org.opendaylight.netconf.transport.ssh.SSHServer;
import org.opendaylight.netconf.transport.ssh.SSHTransportChannel;
import org.opendaylight.netconf.transport.ssh.TransportIoService;
import org.opendaylight.netconf.transport.ssh.TransportIoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract sealed class SSHTransportStack
extends AbstractOverlayTransportStack<SSHTransportChannel>
permits SSHClient, SSHServer {
    private static final Logger LOG = LoggerFactory.getLogger(SSHTransportStack.class);
    private final Map<Long, TransportChannel> underlays = new ConcurrentHashMap<Long, TransportChannel>();
    private final Map<Long, Session> sessions = new ConcurrentHashMap<Long, Session>();
    private final TransportIoService ioService;

    SSHTransportStack(TransportChannelListener<? super SSHTransportChannel> listener, FactoryManager factoryManager, IoHandler handler) {
        super(listener);
        this.ioService = new TransportIoService(factoryManager, handler);
        factoryManager.addSessionListener((SessionListener)new Listener());
    }

    protected void onUnderlayChannelEstablished(TransportChannel underlayChannel) {
        LOG.debug("Underlay establishing, attaching SSH to {}", (Object)underlayChannel);
        Channel channel = underlayChannel.channel();
        TransportIoSession ioSession = this.ioService.createSession(channel.localAddress());
        channel.pipeline().addLast(new ChannelHandler[]{ioSession.handler()});
        this.underlays.put(ioSession.getId(), underlayChannel);
    }

    abstract void onKeyEstablished(Session var1) throws IOException;

    abstract void onAuthenticated(Session var1) throws IOException;

    final @NonNull TransportChannel getUnderlayOf(Long sessionId) throws IOException {
        TransportChannel ret = this.underlays.get(sessionId);
        if (ret == null) {
            throw new IOException("Cannot find underlay for " + sessionId);
        }
        return ret;
    }

    final void transportEstablished(Long sessionId, ChannelHandlerContext head) {
        this.completeUnderlay(sessionId, underlay -> {
            LOG.debug("Established transport on session {}", (Object)sessionId);
            this.addTransportChannel((TransportChannel)new SSHTransportChannel((TransportChannel)underlay));
            head.fireChannelActive();
        });
    }

    @NonNullByDefault
    final void transportFailed(Long sessionId, Throwable cause) {
        this.sessions.remove(sessionId);
        this.completeUnderlay(sessionId, underlay -> {
            underlay.channel().close();
            this.notifyTransportChannelFailed(cause);
        });
    }

    @NonNullByDefault
    private void completeUnderlay(Long sessionId, Consumer<TransportChannel> action) {
        TransportChannel removed = this.underlays.remove(sessionId);
        if (removed != null) {
            action.accept(removed);
        }
    }

    static final @NonNull Long sessionId(Session session) {
        return session.getIoSession().getId();
    }

    @VisibleForTesting
    Collection<Session> getSessions() {
        return this.sessions.values();
    }

    private final class Listener
    implements SessionListener {
        private Listener() {
        }

        public void sessionCreated(Session session) {
            SSHTransportStack.this.sessions.put(SSHTransportStack.sessionId(session), session);
        }

        public void sessionException(Session session, Throwable cause) {
            Long sessionId = SSHTransportStack.sessionId(session);
            LOG.warn("Session {} encountered an error", (Object)sessionId, (Object)cause);
            SSHTransportStack.this.transportFailed(sessionId, cause);
        }

        public void sessionDisconnect(Session session, int reason, String msg, String language, boolean initiator) {
            Long sessionId = SSHTransportStack.sessionId(session);
            StringBuilder sb = new StringBuilder(SshConstants.getDisconnectReasonName((int)reason));
            if (msg != null) {
                sb.append(" \"").append(msg).append('\"');
            }
            String reasonStr = sb.toString();
            LOG.debug("Session {} disconnected: {}", (Object)sessionId, (Object)reasonStr);
            SSHTransportStack.this.transportFailed(sessionId, new EOFException("Session disconnected: " + reasonStr));
        }

        public void sessionClosed(Session session) {
            Long sessionId = SSHTransportStack.sessionId(session);
            LOG.debug("Session {} closed", (Object)sessionId);
            SSHTransportStack.this.transportFailed(sessionId, new EOFException("Session " + sessionId + " closed"));
        }

        public void sessionEvent(Session session, SessionListener.Event event) {
            Long sessionId = SSHTransportStack.sessionId(session);
            SessionListener.Event event2 = event;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"KeyEstablished", "Authenticated", "KexCompleted"}, (SessionListener.Event)event2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case -1: {
                    throw new NullPointerException();
                }
                case 0: {
                    LOG.debug("New key established on session {}", (Object)sessionId);
                    try {
                        SSHTransportStack.this.onKeyEstablished(session);
                    }
                    catch (IOException e) {
                        LOG.error("Post-key step failed on session {}", (Object)sessionId, (Object)e);
                        SSHTransportStack.this.transportFailed(sessionId, e);
                    }
                    break;
                }
                case 1: {
                    LOG.debug("Authentication on session {} successful", (Object)sessionId);
                    try {
                        SSHTransportStack.this.onAuthenticated(session);
                    }
                    catch (IOException e) {
                        LOG.error("Post-authentication step failed on session {}", (Object)sessionId, (Object)e);
                        SSHTransportStack.this.transportFailed(sessionId, e);
                    }
                    break;
                }
                case 2: {
                    LOG.debug("Key exchange completed on session {}", (Object)sessionId);
                }
            }
        }
    }
}

