/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.collect.ImmutableList;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.client.keyverifier.ServerKeyVerifier;
import org.opendaylight.netconf.shaded.sshd.client.session.ClientSession;

final class ServerPublicKeyVerifier
implements ServerKeyVerifier {
    final List<PublicKey> publicKeys;

    ServerPublicKeyVerifier(List<Certificate> certificates, List<PublicKey> publicKeys) {
        Objects.requireNonNull(certificates);
        Objects.requireNonNull(publicKeys);
        this.publicKeys = ImmutableList.builder().addAll(publicKeys).addAll(certificates.stream().map(Certificate::getPublicKey).toList()).build();
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress socketAddress, PublicKey publicKey) {
        return this.publicKeys.contains(publicKey);
    }
}

