/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import org.opendaylight.netconf.shaded.sshd.common.io.IoInputStream;
import org.opendaylight.netconf.shaded.sshd.common.io.IoOutputStream;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelDataReceiver;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSession;
import org.opendaylight.netconf.shaded.sshd.server.channel.ChannelSessionAware;
import org.opendaylight.netconf.shaded.sshd.server.command.AbstractCommandSupport;
import org.opendaylight.netconf.shaded.sshd.server.command.AsyncCommand;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransportServerSubsystem
extends AbstractCommandSupport
implements AsyncCommand,
ChannelSessionAware,
ChannelDataReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(TransportServerSubsystem.class);
    private final TransportChannel underlay;
    private SettableFuture<ChannelHandlerContext> future;
    private ChannelHandlerContext head;

    TransportServerSubsystem(String name, TransportChannel underlay, SettableFuture<ChannelHandlerContext> future) {
        super(name, null);
        this.underlay = Objects.requireNonNull(underlay);
        this.future = Objects.requireNonNull(future);
    }

    public void run() {
    }

    public void setIoInputStream(IoInputStream in) {
    }

    public void setIoErrorStream(IoOutputStream err) {
    }

    public void setIoOutputStream(IoOutputStream out) {
        this.head = TransportUtils.attachUnderlay(out, this.underlay, () -> this.onExit(0));
    }

    public void setChannelSession(ChannelSession session) {
        session.setDataReceiver((ChannelDataReceiver)this);
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) {
        if (len > 0) {
            LOG.debug("Forwarding {} bytes of data on {}", (Object)len, (Object)channel);
            this.head.fireChannelRead((Object)Unpooled.copiedBuffer((byte[])buf, (int)start, (int)len));
        }
        return len;
    }

    public void close() {
    }

    void onPrepareComplete() {
        this.future.set((Object)((ChannelHandlerContext)Verify.verifyNotNull((Object)this.head, (String)"setIoOutputStream() should have been called", (Object[])new Object[0])));
        this.future = null;
    }
}

