/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.opendaylight.netconf.shaded.sshd.client.ClientBuilder;
import org.opendaylight.netconf.shaded.sshd.client.ClientFactoryManager;
import org.opendaylight.netconf.shaded.sshd.client.SshClient;
import org.opendaylight.netconf.shaded.sshd.client.auth.hostbased.HostKeyIdentityProvider;
import org.opendaylight.netconf.shaded.sshd.client.auth.hostbased.UserAuthHostBasedFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.password.PasswordIdentityProvider;
import org.opendaylight.netconf.shaded.sshd.client.auth.password.UserAuthPasswordFactory;
import org.opendaylight.netconf.shaded.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.shaded.sshd.common.FactoryManager;
import org.opendaylight.netconf.shaded.sshd.common.io.IoServiceFactoryFactory;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyIdentityProvider;
import org.opendaylight.netconf.shaded.sshd.netty.NettyIoServiceFactoryFactory;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.ssh.ConfigUtils;
import org.opendaylight.netconf.transport.ssh.ServerPublicKeyVerifier;
import org.opendaylight.netconf.transport.ssh.TransportClientSessionFactory;
import org.opendaylight.netconf.transport.ssh.TransportUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.PasswordType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.password.type.CleartextPassword;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.ClientIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.Keepalives;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.ServerAuthentication;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.client.identity.Hostbased;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.client.identity.Password;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.client.identity.PublicKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.TransportParamsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.InlineOrTruststoreCertsGrouping;

final class TransportSshClient
extends SshClient {
    private TransportSshClient() {
    }

    @Deprecated(forRemoval=true)
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Deprecated(forRemoval=true)
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public void stop() {
        throw new UnsupportedOperationException();
    }

    static final class Builder
    extends ClientBuilder {
        private final NettyIoServiceFactoryFactory ioServiceFactory;
        private final ScheduledExecutorService executorService;
        private ClientFactoryManagerConfigurator configurator;
        private Keepalives keepAlives;
        private ClientIdentity clientIdentity;

        Builder(NettyIoServiceFactoryFactory ioServiceFactory, ScheduledExecutorService executorService) {
            this.ioServiceFactory = Objects.requireNonNull(ioServiceFactory);
            this.executorService = Objects.requireNonNull(executorService);
        }

        Builder transportParams(TransportParamsGrouping params) throws UnsupportedConfigurationException {
            ConfigUtils.setTransportParams(this, params, TransportUtils::getClientKexFactories);
            return this;
        }

        Builder keepAlives(Keepalives newKeepAlives) {
            this.keepAlives = newKeepAlives;
            return this;
        }

        Builder clientIdentity(ClientIdentity newClientIdentity) {
            this.clientIdentity = newClientIdentity;
            return this;
        }

        Builder serverAuthentication(ServerAuthentication serverAuthentication) throws UnsupportedConfigurationException {
            ServerPublicKeyVerifier newVerifier;
            if (serverAuthentication != null) {
                ImmutableList certificatesList = ImmutableList.builder().addAll(ConfigUtils.extractCertificates((InlineOrTruststoreCertsGrouping)serverAuthentication.getCaCerts())).addAll(ConfigUtils.extractCertificates((InlineOrTruststoreCertsGrouping)serverAuthentication.getEeCerts())).build();
                List<java.security.PublicKey> publicKeys = ConfigUtils.extractPublicKeys(serverAuthentication.getSshHostKeys());
                if (certificatesList.isEmpty() && publicKeys.isEmpty()) {
                    throw new UnsupportedConfigurationException("Server authentication should contain either ssh-host-keys, or ca-certs, or ee-certs");
                }
                newVerifier = new ServerPublicKeyVerifier((List<Certificate>)certificatesList, publicKeys);
            } else {
                newVerifier = null;
            }
            this.serverKeyVerifier(newVerifier);
            return this;
        }

        Builder configurator(ClientFactoryManagerConfigurator newConfigurator) {
            this.configurator = newConfigurator;
            return this;
        }

        TransportSshClient buildChecked() throws UnsupportedConfigurationException {
            TransportSshClient ret = (TransportSshClient)super.build(true);
            if (this.keepAlives != null) {
                ConfigUtils.setKeepAlives((FactoryManager)ret, this.keepAlives.getMaxWait(), this.keepAlives.getMaxAttempts());
            } else {
                ConfigUtils.setKeepAlives((FactoryManager)ret, null, null);
            }
            if (this.clientIdentity == null) {
                throw new UnsupportedConfigurationException("Client parameters are required");
            }
            String username = this.clientIdentity.getUsername();
            if (username == null) {
                throw new UnsupportedConfigurationException("Client parameters are missing username");
            }
            if (this.clientIdentity != null && this.clientIdentity.getNone() == null) {
                Builder.setClientIdentity(ret, this.clientIdentity, this.configurator == null);
            }
            if (this.configurator != null) {
                this.configurator.configureClientFactoryManager((ClientFactoryManager)ret);
            }
            ret.setIoServiceFactoryFactory((IoServiceFactoryFactory)this.ioServiceFactory);
            ret.setScheduledExecutorService(this.executorService);
            try {
                ret.checkConfig();
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedConfigurationException("Inconsistent client configuration", (Throwable)e);
            }
            ret.setSessionFactory(new TransportClientSessionFactory(ret, username));
            return ret;
        }

        @Deprecated(forRemoval=true)
        @DoNotCall(value="Always throws UnsupportedOperationException")
        public TransportSshClient build() {
            throw new UnsupportedOperationException();
        }

        @Deprecated(forRemoval=true)
        @DoNotCall(value="Always throws UnsupportedOperationException")
        public TransportSshClient build(boolean isFillWithDefaultValues) {
            throw new UnsupportedOperationException();
        }

        protected ClientBuilder fillWithDefaultValues() {
            if (this.factory == null) {
                this.factory = TransportSshClient::new;
            }
            return super.fillWithDefaultValues();
        }

        private static void setClientIdentity(TransportSshClient client, ClientIdentity clientIdentity, boolean throwExceptionIfNoAuthMethodDefined) throws UnsupportedConfigurationException {
            ImmutableList userAuthFactories;
            PublicKey publicKey;
            Hostbased hostBased;
            PasswordType passwordType;
            ImmutableList.Builder authFactoriesListBuilder = ImmutableList.builder();
            Password password = clientIdentity.getPassword();
            if (password != null && (passwordType = password.getPasswordType()) instanceof CleartextPassword) {
                CleartextPassword clearTextPassword = (CleartextPassword)passwordType;
                client.setPasswordIdentityProvider(PasswordIdentityProvider.wrapPasswords((String[])new String[]{clearTextPassword.requireCleartextPassword()}));
                authFactoriesListBuilder.add((Object)new UserAuthPasswordFactory());
            }
            if ((hostBased = clientIdentity.getHostbased()) != null) {
                KeyPair keyPair = ConfigUtils.extractKeyPair(hostBased.getInlineOrKeystore());
                UserAuthHostBasedFactory factory = new UserAuthHostBasedFactory();
                factory.setClientHostKeys(HostKeyIdentityProvider.wrap((KeyPair[])new KeyPair[]{keyPair}));
                factory.setClientUsername(clientIdentity.getUsername());
                factory.setClientHostname(null);
                factory.setSignatureFactories(client.getSignatureFactories());
                authFactoriesListBuilder.add((Object)factory);
            }
            if ((publicKey = clientIdentity.getPublicKey()) != null) {
                KeyPair keyPairs = ConfigUtils.extractKeyPair(publicKey.getInlineOrKeystore());
                client.setKeyIdentityProvider(KeyIdentityProvider.wrapKeyPairs((KeyPair[])new KeyPair[]{keyPairs}));
                authFactoriesListBuilder.add((Object)new UserAuthPublicKeyFactory(client.getSignatureFactories()));
            }
            if (!(userAuthFactories = authFactoriesListBuilder.build()).isEmpty()) {
                client.setUserAuthFactories((List)userAuthFactories);
            } else if (throwExceptionIfNoAuthMethodDefined) {
                throw new UnsupportedConfigurationException("Client Identity has no authentication mechanism defined");
            }
        }
    }
}

