/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.ssh;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.shaded.sshd.client.ClientBuilder;
import org.opendaylight.netconf.shaded.sshd.common.BaseBuilder;
import org.opendaylight.netconf.shaded.sshd.common.NamedFactory;
import org.opendaylight.netconf.shaded.sshd.common.channel.ChannelAsyncOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.cipher.BuiltinCiphers;
import org.opendaylight.netconf.shaded.sshd.common.cipher.Cipher;
import org.opendaylight.netconf.shaded.sshd.common.io.IoOutputStream;
import org.opendaylight.netconf.shaded.sshd.common.kex.BuiltinDHFactories;
import org.opendaylight.netconf.shaded.sshd.common.kex.KeyExchangeFactory;
import org.opendaylight.netconf.shaded.sshd.common.mac.BuiltinMacs;
import org.opendaylight.netconf.shaded.sshd.common.signature.BuiltinSignatures;
import org.opendaylight.netconf.shaded.sshd.common.signature.Signature;
import org.opendaylight.netconf.shaded.sshd.server.ServerBuilder;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.OutboundChannelHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.SshEncryptionAlgorithm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.SshKeyExchangeAlgorithm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.SshMacAlgorithm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.SshPublicKeyAlgorithm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.transport.params.grouping.Encryption;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.transport.params.grouping.HostKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.transport.params.grouping.KeyExchange;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.common.rev241010.transport.params.grouping.Mac;

final class TransportUtils {
    private static final Map<SshEncryptionAlgorithm, NamedFactory<Cipher>> CIPHERS = ImmutableMap.builder().put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.AEADAES128GCM), (Object)BuiltinCiphers.aes128gcm).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.AEADAES256GCM), (Object)BuiltinCiphers.aes256cbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes128Cbc), (Object)BuiltinCiphers.aes128cbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes128Ctr), (Object)BuiltinCiphers.aes128ctr).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes192Cbc), (Object)BuiltinCiphers.aes192cbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes192Ctr), (Object)BuiltinCiphers.aes192ctr).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes256Cbc), (Object)BuiltinCiphers.aes256cbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Aes256Ctr), (Object)BuiltinCiphers.aes256ctr).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Arcfour128), (Object)BuiltinCiphers.arcfour128).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.Arcfour256), (Object)BuiltinCiphers.arcfour256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.BlowfishCbc), (Object)BuiltinCiphers.blowfishcbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm._3desCbc), (Object)BuiltinCiphers.tripledescbc).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm.None), (Object)BuiltinCiphers.none).build();
    private static final List<NamedFactory<Cipher>> DEFAULT_CIPHERS = ImmutableList.builder().addAll((Iterable)BaseBuilder.DEFAULT_CIPHERS_PREFERENCE).build();
    private static final Map<SshKeyExchangeAlgorithm, KeyExchangeFactory> CLIENT_KEXS;
    private static final ImmutableMap<SshKeyExchangeAlgorithm, KeyExchangeFactory> SERVER_KEXS;
    private static final List<KeyExchangeFactory> DEFAULT_CLIENT_KEXS;
    private static final List<KeyExchangeFactory> DEFAULT_SERVER_KEXS;
    private static final ImmutableMap<SshMacAlgorithm, NamedFactory<org.opendaylight.netconf.shaded.sshd.common.mac.Mac>> MACS;
    private static final List<NamedFactory<org.opendaylight.netconf.shaded.sshd.common.mac.Mac>> DEFAULT_MACS;
    static final Map<SshPublicKeyAlgorithm, NamedFactory<Signature>> SIGNATURES;
    static final List<NamedFactory<Signature>> DEFAULT_SIGNATURES;

    private TransportUtils() {
    }

    public static List<NamedFactory<Cipher>> getCipherFactories(@Nullable Encryption encryption) throws UnsupportedConfigurationException {
        List encAlg;
        if (encryption != null && (encAlg = encryption.getEncryptionAlg()) != null && !encAlg.isEmpty()) {
            return TransportUtils.mapValues(CIPHERS, encAlg, "Unsupported Encryption algorithm %s");
        }
        return DEFAULT_CIPHERS;
    }

    public static List<NamedFactory<Signature>> getSignatureFactories(@Nullable HostKey hostKey) throws UnsupportedConfigurationException {
        List hostKeyAlg;
        if (hostKey != null && (hostKeyAlg = hostKey.getHostKeyAlg()) != null && hostKeyAlg.isEmpty()) {
            return TransportUtils.mapValues(SIGNATURES, hostKeyAlg, "Unsupported Host Key algorithm %s");
        }
        return DEFAULT_SIGNATURES;
    }

    public static List<KeyExchangeFactory> getClientKexFactories(KeyExchange keyExchange) throws UnsupportedConfigurationException {
        return TransportUtils.getKexFactories(keyExchange, CLIENT_KEXS, DEFAULT_CLIENT_KEXS);
    }

    public static List<KeyExchangeFactory> getServerKexFactories(KeyExchange keyExchange) throws UnsupportedConfigurationException {
        return TransportUtils.getKexFactories(keyExchange, SERVER_KEXS, DEFAULT_SERVER_KEXS);
    }

    private static List<KeyExchangeFactory> getKexFactories(KeyExchange keyExchange, Map<SshKeyExchangeAlgorithm, KeyExchangeFactory> map, List<KeyExchangeFactory> defaultResult) throws UnsupportedConfigurationException {
        List kexAlg;
        if (keyExchange != null && (kexAlg = keyExchange.getKeyExchangeAlg()) != null && !kexAlg.isEmpty()) {
            return TransportUtils.mapValues(map, kexAlg, "Unsupported Key Exchange algorithm %s");
        }
        return defaultResult;
    }

    public static List<NamedFactory<org.opendaylight.netconf.shaded.sshd.common.mac.Mac>> getMacFactories(Mac mac) throws UnsupportedConfigurationException {
        List macAlg;
        if (mac != null && (macAlg = mac.getMacAlg()) != null && !macAlg.isEmpty()) {
            return TransportUtils.mapValues(MACS, macAlg, "Unsupported MAC algorithm %s");
        }
        return DEFAULT_MACS;
    }

    private static <K, V> List<V> mapValues(Map<K, V> map, List<K> values, String errorTemplate) throws UnsupportedConfigurationException {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)values.size());
        for (K value : values) {
            V mapped = map.get(value);
            if (mapped == null) {
                throw new UnsupportedOperationException(String.format(errorTemplate, value));
            }
            builder.add(mapped);
        }
        return builder.build();
    }

    private static SshEncryptionAlgorithm wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.encryption.algs.rev241016.SshEncryptionAlgorithm alg) {
        return new SshEncryptionAlgorithm(alg);
    }

    private static SshKeyExchangeAlgorithm wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm alg) {
        return new SshKeyExchangeAlgorithm(alg);
    }

    private static SshMacAlgorithm wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm alg) {
        return new SshMacAlgorithm(alg);
    }

    private static SshPublicKeyAlgorithm wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm alg) {
        return new SshPublicKeyAlgorithm(alg);
    }

    static <T> T checkCast(Class<T> clazz, Object obj) throws IOException {
        try {
            return clazz.cast(Objects.requireNonNull(obj));
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
    }

    static ChannelHandlerContext attachUnderlay(IoOutputStream out, TransportChannel underlay, ChannelInactive inactive) {
        if (!(out instanceof ChannelAsyncOutputStream)) {
            throw new VerifyException("Unexpected output " + String.valueOf(out));
        }
        ChannelAsyncOutputStream asyncOut = (ChannelAsyncOutputStream)out;
        ChannelPipeline pipeline = underlay.channel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new OutboundChannelHandler(asyncOut)});
        underlay.channel().closeFuture().addListener(future -> inactive.onChannelInactive());
        return pipeline.lastContext();
    }

    static {
        Map factories = Maps.filterValues((Map)ImmutableMap.builder().put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.Curve25519Sha256), (Object)BuiltinDHFactories.curve25519).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.Curve448Sha512), (Object)BuiltinDHFactories.curve448).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup1Sha1), (Object)BuiltinDHFactories.dhg1).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup14Sha1), (Object)BuiltinDHFactories.dhg14).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup14Sha256), (Object)BuiltinDHFactories.dhg14_256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup15Sha512), (Object)BuiltinDHFactories.dhg15_512).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup16Sha512), (Object)BuiltinDHFactories.dhg16_512).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup17Sha512), (Object)BuiltinDHFactories.dhg17_512).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroup18Sha512), (Object)BuiltinDHFactories.dhg18_512).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroupExchangeSha1), (Object)BuiltinDHFactories.dhgex).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.DiffieHellmanGroupExchangeSha256), (Object)BuiltinDHFactories.dhgex256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.EcdhSha2Nistp256), (Object)BuiltinDHFactories.ecdhp256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.EcdhSha2Nistp384), (Object)BuiltinDHFactories.ecdhp384).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.key.exchange.algs.rev241016.SshKeyExchangeAlgorithm.EcdhSha2Nistp521), (Object)BuiltinDHFactories.ecdhp521).build(), BuiltinDHFactories::isSupported);
        CLIENT_KEXS = ImmutableMap.copyOf((Map)Maps.transformValues((Map)factories, ClientBuilder.DH2KEX::apply));
        SERVER_KEXS = ImmutableMap.copyOf((Map)Maps.transformValues((Map)factories, ServerBuilder.DH2KEX::apply));
        DEFAULT_CLIENT_KEXS = ImmutableList.copyOf((Collection)Lists.transform((List)BaseBuilder.DEFAULT_KEX_PREFERENCE, ClientBuilder.DH2KEX::apply));
        DEFAULT_SERVER_KEXS = ImmutableList.copyOf((Collection)Lists.transform((List)BaseBuilder.DEFAULT_KEX_PREFERENCE, ServerBuilder.DH2KEX::apply));
        MACS = ImmutableMap.builder().put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacMd5), (Object)BuiltinMacs.hmacmd5).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacMd596), (Object)BuiltinMacs.hmacmd596).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacSha1), (Object)BuiltinMacs.hmacsha1).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacSha196), (Object)BuiltinMacs.hmacsha196).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacSha2256), (Object)BuiltinMacs.hmacsha256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh.mac.algs.rev241016.SshMacAlgorithm.HmacSha2512), (Object)BuiltinMacs.hmacsha512).build();
        DEFAULT_MACS = ImmutableList.builder().addAll((Iterable)BaseBuilder.DEFAULT_MAC_PREFERENCE).build();
        SIGNATURES = ImmutableMap.builder().put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.EcdsaSha2Nistp256), (Object)BuiltinSignatures.nistp256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.EcdsaSha2Nistp384), (Object)BuiltinSignatures.nistp384).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.EcdsaSha2Nistp521), (Object)BuiltinSignatures.nistp521).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.RsaSha2512), (Object)BuiltinSignatures.rsaSHA512).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.RsaSha2256), (Object)BuiltinSignatures.rsaSHA256).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.SshDss), (Object)BuiltinSignatures.dsa).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.SshEd25519), (Object)BuiltinSignatures.ed25519).put((Object)TransportUtils.wrap(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.ssh._public.key.algs.rev241016.SshPublicKeyAlgorithm.SshRsa), (Object)BuiltinSignatures.rsa).build();
        DEFAULT_SIGNATURES = ImmutableList.builder().addAll((Iterable)BaseBuilder.DEFAULT_SIGNATURE_PREFERENCE).build();
    }

    @FunctionalInterface
    static interface ChannelInactive {
        public void onChannelInactive() throws Exception;
    }
}

