/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tcp;

import com.google.common.base.MoreObjects;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.tcp.NettyTransportSupport;

public class BootstrapFactory
implements AutoCloseable {
    protected final @NonNull EventLoopGroup group;
    private final EventLoopGroup parentGroup;

    private BootstrapFactory(EventLoopGroup group, EventLoopGroup parentGroup) {
        this.group = Objects.requireNonNull(group);
        this.parentGroup = parentGroup;
    }

    public BootstrapFactory(@NonNull String groupName, int groupThreads) {
        this(NettyTransportSupport.newEventLoopGroup(groupName, groupThreads), null);
    }

    public BootstrapFactory(@NonNull String groupName, int groupThreads, @NonNull String parentGroupName, int parentGroupThreads) {
        this(NettyTransportSupport.newEventLoopGroup(groupName, groupThreads), NettyTransportSupport.newEventLoopGroup(parentGroupName, parentGroupThreads));
    }

    public final @NonNull Bootstrap newBootstrap() {
        return (Bootstrap)NettyTransportSupport.newBootstrap().group(this.group);
    }

    public final @NonNull ServerBootstrap newServerBootstrap() {
        return NettyTransportSupport.newServerBootstrap().group(this.parentGroup != null ? this.parentGroup : this.group, this.group);
    }

    @Override
    public final void close() {
        if (this.parentGroup != null) {
            this.parentGroup.shutdownGracefully();
        }
        this.group.shutdownGracefully();
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("group", (Object)this.group).add("parentGroup", (Object)this.parentGroup);
    }
}

