/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tcp;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.NettyTransportSupport;
import org.opendaylight.netconf.transport.tcp.TCPTransportChannel;
import org.opendaylight.netconf.transport.tcp.TCPTransportStack;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.common.rev241010.tcp.common.grouping.Keepalives;
import org.opendaylight.yangtools.yang.common.Empty;

public final class TCPClient
extends TCPTransportStack {
    private TCPClient(TransportChannelListener<? super TCPTransportChannel> listener) {
        super(listener);
    }

    public static @NonNull ListenableFuture<TCPClient> connect(TransportChannelListener listener, Bootstrap bootstrap, TcpClientGrouping connectParams) throws UnsupportedConfigurationException {
        Keepalives keepalives = connectParams.getKeepalives();
        if (keepalives != null) {
            NettyTcpKeepaliveOptions options = NettyTransportSupport.getTcpKeepaliveOptions();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE)).option(options.tcpKeepIdle(), (Object)keepalives.requireIdleTime().toJava())).option(options.tcpKeepCnt(), (Object)keepalives.requireMaxProbes().toJava())).option(options.tcpKeepIntvl(), (Object)keepalives.requireProbeInterval().toJava());
        }
        final SettableFuture ret = SettableFuture.create();
        final TCPClient stack = new TCPClient((TransportChannelListener<? super TCPTransportChannel>)listener);
        ((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ret.set((Object)stack);
                Channel channel = ctx.channel();
                stack.addTransportChannel(new TCPTransportChannel(channel));
                ctx.fireChannelActive();
                channel.pipeline().remove((ChannelHandler)this);
            }
        })).connect((SocketAddress)TCPClient.socketAddressOf(connectParams.requireRemoteAddress(), connectParams.requireRemotePort()), (SocketAddress)TCPClient.socketAddressOf(connectParams.getLocalAddress(), connectParams.getLocalPort())).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                ret.setException(cause);
            }
        }));
        return ret;
    }

    protected ListenableFuture<Empty> startShutdown() {
        return Empty.immediateFuture();
    }
}

