/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.spi.NettyTcpKeepaliveOptions;
import org.opendaylight.netconf.transport.spi.NettyTransportSupport;
import org.opendaylight.netconf.transport.tcp.TCPTransportChannel;
import org.opendaylight.netconf.transport.tcp.TCPTransportStack;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.common.rev241010.tcp.common.grouping.Keepalives;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.tcp.server.grouping.LocalBind;
import org.opendaylight.yangtools.yang.common.Empty;

public final class TCPServer
extends TCPTransportStack {
    private volatile Channel listenChannel;

    private TCPServer(TransportChannelListener<? super TCPTransportChannel> listener) {
        super(listener);
    }

    public static @NonNull ListenableFuture<TCPServer> listen(TransportChannelListener listener, ServerBootstrap bootstrap, TcpServerGrouping listenParams) throws UnsupportedConfigurationException {
        Collection localBinds = listenParams.nonnullLocalBind().values();
        switch (localBinds.size()) {
            case 0: {
                throw new UnsupportedConfigurationException("No bind addresses provided");
            }
            case 1: {
                break;
            }
            default: {
                throw new UnsupportedConfigurationException("Multiple bind addresses provided");
            }
        }
        LocalBind localBind = (LocalBind)localBinds.iterator().next();
        Keepalives keepalives = listenParams.getKeepalives();
        if (keepalives != null) {
            NettyTcpKeepaliveOptions options = NettyTransportSupport.getTcpKeepaliveOptions();
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).childOption(options.tcpKeepIdle(), (Object)keepalives.requireIdleTime().toJava()).childOption(options.tcpKeepCnt(), (Object)keepalives.requireMaxProbes().toJava()).childOption(options.tcpKeepIntvl(), (Object)keepalives.requireProbeInterval().toJava());
        }
        SettableFuture ret = SettableFuture.create();
        TCPServer stack = new TCPServer((TransportChannelListener<? super TCPTransportChannel>)listener);
        ListenChannelInitializer initializer = new ListenChannelInitializer(stack);
        bootstrap.childHandler((ChannelHandler)initializer).bind((SocketAddress)TCPServer.socketAddressOf(localBind.requireLocalAddress(), localBind.requireLocalPort())).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                stack.setListenChannel(future.channel());
                ret.set((Object)stack);
            } else {
                ret.setException(cause);
            }
        }));
        return ret;
    }

    protected ListenableFuture<Empty> startShutdown() {
        return TCPServer.toListenableFuture((Future)this.listenChannel().close());
    }

    @VisibleForTesting
    @NonNull Channel listenChannel() {
        return (Channel)Verify.verifyNotNull((Object)this.listenChannel, (String)"Channel not initialized", (Object[])new Object[0]);
    }

    private void setListenChannel(Channel listenChannel) {
        this.listenChannel = Objects.requireNonNull(listenChannel);
    }

    @ChannelHandler.Sharable
    private static final class ListenChannelInitializer
    extends ChannelInitializer<Channel> {
        private final TCPServer stack;

        ListenChannelInitializer(TCPServer stack) {
            this.stack = Objects.requireNonNull(stack);
        }

        protected void initChannel(Channel ch) {
            ((TCPServer)((Object)Verify.verifyNotNull((Object)((Object)this.stack), (String)"Stack not initialized while handling channel %s", (Object[])new Object[]{ch}))).addTransportChannel(new TCPTransportChannel(ch));
        }
    }
}

